/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class EjbDependsOnAnnotationProcessor
extends AbstractComponentConfigProcessor {
    private static final Logger logger = Logger.getLogger(EjbDependsOnAnnotationProcessor.class);

    protected final void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        String[] annotationValues;
        ClassInfo beanClass = index.getClassByName(DotName.createSimple((String)componentDescription.getComponentClassName()));
        if (beanClass == null) {
            return;
        }
        Class<SingletonComponentDescription> componentDescriptionType = SingletonComponentDescription.class;
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit) || !componentDescriptionType.isAssignableFrom(componentDescription.getClass())) {
            return;
        }
        Map annotationsOnBean = beanClass.annotations();
        if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
            return;
        }
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        final SingletonComponentDescription singletonComponentDescription = (SingletonComponentDescription)((Object)componentDescriptionType.cast(componentDescription));
        List dependsOnAnnotations = (List)annotationsOnBean.get(DotName.createSimple((String)DependsOn.class.getName()));
        if (dependsOnAnnotations == null || dependsOnAnnotations.isEmpty()) {
            return;
        }
        this.validate(annotationsOnBean, dependsOnAnnotations, singletonComponentDescription.getEJBName());
        AnnotationInstance dependsOnAnnotation = (AnnotationInstance)dependsOnAnnotations.get(0);
        for (String annotationValue : annotationValues = dependsOnAnnotation.value().asStringArray()) {
            Set components = applicationDescription.getComponents(annotationValue, deploymentRoot.getRoot());
            if (components.isEmpty()) {
                throw new DeploymentUnitProcessingException("Could not find EJB " + annotationValue + " referenced by @DependsOn annotation in " + componentDescription.getComponentClassName());
            }
            if (components.size() != 1) {
                throw new DeploymentUnitProcessingException("More than one EJB called" + annotationValue + " referenced by @DependsOn annotation in " + componentDescription.getComponentClassName() + " Components: " + components);
            }
            ComponentDescription component = (ComponentDescription)components.iterator().next();
            ServiceName serviceName = this.createServiceName(component);
            singletonComponentDescription.getDependsOn().add(serviceName);
            componentDescription.addDependency(this.createServiceName(component), ServiceBuilder.DependencyType.REQUIRED);
        }
        logger.info((Object)(singletonComponentDescription.getEJBName() + " bean has @DependsOn"));
        componentDescription.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                    public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                        for (ServiceName dep : singletonComponentDescription.getDependsOn()) {
                            serviceBuilder.addDependency(dep);
                        }
                    }
                });
            }
        });
    }

    private void validate(Map<DotName, List<AnnotationInstance>> annotationsOnBean, List<AnnotationInstance> dependsOnAnnotations, String beanName) throws DeploymentUnitProcessingException {
        if (dependsOnAnnotations.size() > 1) {
            throw new DeploymentUnitProcessingException("More than one @DependsOn annotation found on bean: " + beanName);
        }
        AnnotationInstance dependsOnAnnotation = dependsOnAnnotations.get(0);
        List<AnnotationInstance> singletonAnnotations = annotationsOnBean.get(DotName.createSimple((String)Singleton.class.getName()));
        if (singletonAnnotations == null || singletonAnnotations.isEmpty()) {
            throw new DeploymentUnitProcessingException("@DependsOn can appear only on a class annotated with @Singleton. Target: " + dependsOnAnnotation.target() + " is not a class.");
        }
        if (!(dependsOnAnnotation.target() instanceof ClassInfo)) {
            throw new DeploymentUnitProcessingException("@DependsOn can appear only on a class. Target: " + dependsOnAnnotation.target() + " is not a class.");
        }
    }

    private ServiceName createServiceName(ComponentDescription componentDescription) {
        ServiceName beanServiceName = componentDescription.getServiceName().append(new String[]{"START"});
        return beanServiceName;
    }
}

