/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.AfterBegin;
import javax.ejb.AfterCompletion;
import javax.ejb.BeforeCompletion;
import javax.ejb.SessionSynchronization;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class SessionSynchronizationProcessor
extends AbstractAnnotationEJBProcessor<StatefulComponentDescription> {
    private static final DotName AFTER_BEGIN = DotName.createSimple((String)AfterBegin.class.getName());
    private static final DotName AFTER_COMPLETION = DotName.createSimple((String)AfterCompletion.class.getName());
    private static final DotName BEFORE_COMPLETION = DotName.createSimple((String)BeforeCompletion.class.getName());

    @Override
    protected Class<StatefulComponentDescription> getComponentDescriptionType() {
        return StatefulComponentDescription.class;
    }

    private static boolean implementsSessionSynchronization(ClassInfo classInfo) {
        for (DotName intf : classInfo.interfaces()) {
            if (!intf.toString().equals(SessionSynchronization.class.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, final StatefulComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo superClass;
        DotName superName = beanClass.superName();
        if (superName != null && (superClass = index.getClassByName(superName)) != null) {
            this.processAnnotations(superClass, index, componentDescription);
        }
        if (SessionSynchronizationProcessor.implementsSessionSynchronization(beanClass)) {
            componentDescription.setAfterBegin(null, "afterBegin");
            componentDescription.setAfterCompletion(null, "afterCompletion");
            componentDescription.setBeforeCompletion(null, "beforeCompletion");
            return;
        }
        Map classAnnotations = beanClass.annotations();
        if (classAnnotations == null) {
            return;
        }
        SessionSynchronizationProcessor.processClassAnnotations(classAnnotations, AFTER_BEGIN, new MethodProcessor(){

            @Override
            public void process(MethodInfo method) {
                componentDescription.setAfterBegin(method.declaringClass().toString(), method.name().toString());
            }
        });
        SessionSynchronizationProcessor.processClassAnnotations(classAnnotations, AFTER_COMPLETION, new MethodProcessor(){

            @Override
            public void process(MethodInfo method) {
                componentDescription.setAfterCompletion(method.declaringClass().toString(), method.name().toString());
            }
        });
        SessionSynchronizationProcessor.processClassAnnotations(classAnnotations, BEFORE_COMPLETION, new MethodProcessor(){

            @Override
            public void process(MethodInfo method) {
                componentDescription.setBeforeCompletion(method.declaringClass().toString(), method.name().toString());
            }
        });
    }

    private static void processClassAnnotations(Map<DotName, List<AnnotationInstance>> classAnnotations, DotName annotationName, MethodProcessor methodProcessor) throws DeploymentUnitProcessingException {
        List<AnnotationInstance> annotations = classAnnotations.get(annotationName);
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        if (annotations.size() > 1) {
            throw new DeploymentUnitProcessingException("EJB 3.1 FR 4.9.4: at most one session synchronization method is allowed for " + annotationName);
        }
        MethodInfo method = (MethodInfo)annotations.get(0).target();
        methodProcessor.process(method);
    }

    private static interface MethodProcessor {
        public void process(MethodInfo var1);
    }
}

