/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.Locale;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.deployment.processors.AccessTimeoutAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.ApplicationExceptionAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.AsynchronousAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.BusinessViewAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.ConcurrencyManagementAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.DeclareRolesProcessor;
import org.jboss.as.ejb3.deployment.processors.DenyAllProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbCleanUpProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbContextJndiBindingProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbDependencyDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbDependsOnAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbInjectionResolutionProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbJarConfigurationProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbJarParsingDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbJndiBindingsDeploymentUnitProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbRefProcessor;
import org.jboss.as.ejb3.deployment.processors.EjbResourceInjectionAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.ImplicitLocalViewProcessor;
import org.jboss.as.ejb3.deployment.processors.LockAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.MessageDrivenComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.MethodPermissionDDProcessor;
import org.jboss.as.ejb3.deployment.processors.PermitAllProcessor;
import org.jboss.as.ejb3.deployment.processors.RemoveAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.ResourceAdapterAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.RolesAllowedProcessor;
import org.jboss.as.ejb3.deployment.processors.RunAsProcessor;
import org.jboss.as.ejb3.deployment.processors.SecurityDomainProcessor;
import org.jboss.as.ejb3.deployment.processors.SessionBeanComponentDescriptionFactory;
import org.jboss.as.ejb3.deployment.processors.SessionSynchronizationProcessor;
import org.jboss.as.ejb3.deployment.processors.StartupAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.StatefulTimeoutAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.TimeoutAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.TimerServiceJndiBindingProcessor;
import org.jboss.as.ejb3.deployment.processors.TransactionAttributeAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.TransactionManagementAnnotationProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.AssemblyDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.DeploymentDescriptorInterceptorBindingsProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.DeploymentDescriptorMethodProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.EjbConcurrencyProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.ExcludeListDDProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.InterceptorClassDeploymentDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.RemoveMethodDeploymentDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.SecurityIdentityDDProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.SecurityRoleRefDDProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.SessionBeanXmlDescriptorProcessor;
import org.jboss.as.ejb3.deployment.processors.dd.TimeoutMethodDeploymentDescriptorProcessor;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemDescriptions;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.SetDefaultMDBPool;
import org.jboss.as.ejb3.subsystem.SetDefaultResourceAdapterName;
import org.jboss.as.ejb3.subsystem.SetDefaultSLSBPool;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.txn.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class EJB3SubsystemAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    static final EJB3SubsystemAdd INSTANCE = new EJB3SubsystemAdd();
    private static final Logger logger = Logger.getLogger(EJB3SubsystemAdd.class);

    private EJB3SubsystemAdd() {
    }

    public ModelNode getModelDescription(Locale locale) {
        return EJB3SubsystemDescriptions.getSubystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("lite").set(operation.get("lite"));
        model.get("default-mdb-instance-pool").set(operation.get("default-mdb-instance-pool"));
        model.get("default-slsb-instance-pool").set(operation.get("default-slsb-instance-pool"));
        model.get("default-resource-adapter-name").set(operation.get("default-resource-adapter-name"));
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, final ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        String poolName;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                boolean lite;
                boolean timerServiceEnabled = false;
                boolean bl = lite = model.hasDefined("lite") && model.get("lite").asBoolean();
                if (!lite && context.readResource(PathAddress.EMPTY_ADDRESS).hasChild(EJB3SubsystemModel.TIMER_SERVICE_PATH)) {
                    timerServiceEnabled = true;
                }
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13313, (DeploymentUnitProcessor)new TimeoutAnnotationProcessor(timerServiceEnabled));
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4352, (DeploymentUnitProcessor)new EjbJarParsingDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4432, (DeploymentUnitProcessor)new SessionBeanComponentDescriptionFactory());
                if (!lite) {
                    logger.debug((Object)"Add support for MDB");
                    processorTarget.addDeploymentProcessor(Phase.PARSE, 4433, (DeploymentUnitProcessor)new MessageDrivenComponentDescriptionFactory());
                }
                processorTarget.addDeploymentProcessor(Phase.PARSE, 4608, (DeploymentUnitProcessor)new SessionBeanXmlDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 11776, (DeploymentUnitProcessor)new EjbContextJndiBindingProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 11777, (DeploymentUnitProcessor)new TimerServiceJndiBindingProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 5632, (DeploymentUnitProcessor)new TransactionManagementAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 14080, (DeploymentUnitProcessor)new EjbResourceInjectionAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6144, (DeploymentUnitProcessor)new StartupAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6400, (DeploymentUnitProcessor)new ConcurrencyManagementAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6656, (DeploymentUnitProcessor)new LockAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6403, (DeploymentUnitProcessor)new DeclareRolesProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6404, (DeploymentUnitProcessor)new RunAsProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6657, (DeploymentUnitProcessor)new StatefulTimeoutAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6912, (DeploymentUnitProcessor)new AccessTimeoutAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 7168, (DeploymentUnitProcessor)new TransactionAttributeAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 7248, (DeploymentUnitProcessor)new SessionSynchronizationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 7424, (DeploymentUnitProcessor)new ResourceAdapterAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 7680, (DeploymentUnitProcessor)new AsynchronousAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6401, (DeploymentUnitProcessor)new ApplicationExceptionAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6402, (DeploymentUnitProcessor)new RemoveAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13568, (DeploymentUnitProcessor)new InterceptorClassDeploymentDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13824, (DeploymentUnitProcessor)new AssemblyDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13569, (DeploymentUnitProcessor)new SecurityRoleRefDDProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 13570, (DeploymentUnitProcessor)new SecurityIdentityDDProcessor());
                processorTarget.addDeploymentProcessor(Phase.PARSE, 6145, (DeploymentUnitProcessor)new SecurityDomainProcessor());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, 0, (DeploymentUnitProcessor)new EjbDependencyDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1024, (DeploymentUnitProcessor)new BusinessViewAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 4096, (DeploymentUnitProcessor)new ImplicitLocalViewProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 4352, (DeploymentUnitProcessor)new EjbJndiBindingsDeploymentUnitProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 4608, (DeploymentUnitProcessor)new EjbJarConfigurationProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1536, (DeploymentUnitProcessor)new DeploymentDescriptorInterceptorBindingsProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1537, (DeploymentUnitProcessor)new EjbConcurrencyProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1025, (DeploymentUnitProcessor)new DeploymentDescriptorMethodProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1280, (DeploymentUnitProcessor)new RemoveMethodDeploymentDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1286, (DeploymentUnitProcessor)new TimeoutMethodDeploymentDescriptorProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1281, (DeploymentUnitProcessor)new DenyAllProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1282, (DeploymentUnitProcessor)new RolesAllowedProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1283, (DeploymentUnitProcessor)new PermitAllProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1284, (DeploymentUnitProcessor)new ExcludeListDDProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 1285, (DeploymentUnitProcessor)new MethodPermissionDDProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 5376, (DeploymentUnitProcessor)new EjbRefProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 1026, (DeploymentUnitProcessor)new EjbInjectionResolutionProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, 4624, (DeploymentUnitProcessor)new EjbDependsOnAnnotationProcessor());
                processorTarget.addDeploymentProcessor(Phase.CLEANUP, 768, (DeploymentUnitProcessor)new EjbCleanUpProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        if (model.hasDefined("default-mdb-instance-pool")) {
            poolName = model.get("default-mdb-instance-pool").asString();
            context.addStep((OperationStepHandler)new SetDefaultMDBPool.DefaultMDBPoolConfigServiceUpdateHandler(poolName), OperationContext.Stage.RUNTIME);
        }
        if (model.hasDefined("default-slsb-instance-pool")) {
            poolName = model.get("default-slsb-instance-pool").asString();
            context.addStep((OperationStepHandler)new SetDefaultSLSBPool.DefaultSLSBPoolConfigServiceUpdateHandler(poolName), OperationContext.Stage.RUNTIME);
        }
        if (model.hasDefined("default-resource-adapter-name")) {
            String raName = model.get("default-resource-adapter-name").asString();
            context.addStep((OperationStepHandler)new SetDefaultResourceAdapterName.DefaultResourceAdapterNameUpdateHandler(raName), OperationContext.Stage.RUNTIME);
        }
        ServiceTarget serviceTarget = context.getServiceTarget();
        EJBUtilities utilities = new EJBUtilities();
        newControllers.add(serviceTarget.addService(EJBUtilities.SERVICE_NAME, (Service)utilities).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, utilities.getResourceAdapterRepositoryInjector()).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, utilities.getMdrInjector()).addDependency(SimpleSecurityManagerService.SERVICE_NAME, SimpleSecurityManager.class, utilities.getSecurityManagerInjector()).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, utilities.getTransactionManagerInjector()).addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, utilities.getTransactionSynchronizationRegistryInjector()).addDependency(TxnServices.JBOSS_TXN_USER_TRANSACTION, UserTransaction.class, utilities.getUserTransactionInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
    }
}

