/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.context.base;

import java.lang.reflect.Method;
import java.security.Identity;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import org.jboss.as.ejb3.context.base.Primitives;
import org.jboss.as.ejb3.context.spi.EJBComponent;
import org.jboss.as.ejb3.context.spi.EJBContext;
import org.jboss.as.ejb3.context.spi.InvocationContext;

public abstract class BaseInvocationContext
implements InvocationContext {
    private final Map<String, Object> contextData = new HashMap<String, Object>();
    protected final boolean lifecycleCallback;
    private final Method method;
    private Object[] parameters;
    private EJBContext instanceContext;
    private Principal callerPrincipal;
    private Timer timer;

    public BaseInvocationContext(Method method, Object[] parameters) {
        this(method == null, method, parameters);
    }

    public BaseInvocationContext(boolean lifecycleCallback, Method method, Object[] parameters) {
        this.lifecycleCallback = lifecycleCallback;
        this.method = method;
        this.parameters = parameters;
    }

    public Identity getCallerIdentity() {
        throw new UnsupportedOperationException("getCallerIdentity is deprecated");
    }

    public Principal getCallerPrincipal() {
        if (this.callerPrincipal == null) {
            throw new IllegalStateException("No callerPrincipal set on " + this);
        }
        return this.callerPrincipal;
    }

    @Override
    public EJBComponent getComponent() {
        return this.getEJBContext().getComponent();
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    @Override
    public EJBContext getEJBContext() {
        if (this.instanceContext == null) {
            throw new IllegalStateException("No instance associated with invocation " + this);
        }
        return this.instanceContext;
    }

    public EJBHome getEJBHome() {
        return this.getComponent().getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.getComponent().getEJBLocalHome();
    }

    public Properties getEnvironment() {
        throw new UnsupportedOperationException("getEnvironment is deprecated");
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        if (this.method == null) {
            throw new IllegalStateException("Getting parameters is not allowed on lifecycle callbacks");
        }
        return this.parameters;
    }

    public boolean getRollbackOnly() {
        this.notAllowedInLifecycleCallbacks("getRollbackOnly");
        return this.getComponent().getRollbackOnly();
    }

    @Override
    public Object getTarget() {
        return this.getEJBContext().getTarget();
    }

    @Override
    public Object getTimer() {
        return this.timer;
    }

    public TimerService getTimerService() {
        return this.getComponent().getTimerService();
    }

    public UserTransaction getUserTransaction() {
        return this.getComponent().getUserTransaction();
    }

    public boolean isCallerInRole(Identity role) {
        throw new IllegalStateException("deprecated");
    }

    public boolean isCallerInRole(String roleName) {
        return this.getComponent().isCallerInRole(this.getCallerPrincipal(), roleName);
    }

    public Object lookup(String name) throws IllegalArgumentException {
        return this.getComponent().lookup(name);
    }

    protected final void notAllowedInLifecycleCallbacks(String name) {
        if (this.lifecycleCallback) {
            throw new IllegalStateException(name + " is not allowed in lifecycle callbacks (EJB 3.1 FR 4.6.1, 4.7.2, 4.8.6, 5.5.1)");
        }
    }

    public abstract Object proceed() throws Exception;

    @Override
    public void setCallerPrincipal(Principal callerPrincipal) {
        this.callerPrincipal = callerPrincipal;
    }

    @Override
    public void setEJBContext(EJBContext instanceContext) {
        this.instanceContext = instanceContext;
    }

    public void setParameters(Object[] params) throws IllegalArgumentException, IllegalStateException {
        if (this.method == null) {
            throw new IllegalStateException("Setting parameters is not allowed on lifecycle callbacks");
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (params != null) {
            if (parameterTypes.length != params.length) {
                throw new IllegalArgumentException("Got wrong number of arguments, expected " + parameterTypes.length + ", got " + params.length + " on " + this.method);
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> actualType;
                Class<?> expectedType = Primitives.normalize(parameterTypes[i]);
                Object param = params[i];
                if (param == null || expectedType.isAssignableFrom(actualType = param.getClass())) continue;
                throw new IllegalArgumentException("Parameter " + i + " has the wrong type, expected " + expectedType + ", got " + actualType + " on " + this.method);
            }
        } else if (parameterTypes.length != 0) {
            throw new IllegalArgumentException("Got wrong number of arguments, expected " + parameterTypes.length + ", got none on " + this.method);
        }
        this.parameters = params;
    }

    public void setRollbackOnly() {
        this.notAllowedInLifecycleCallbacks("setRollbackOnly");
        this.getComponent().setRollbackOnly();
    }

    @Override
    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

