/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;

public abstract class EJBComponentDescriptionFactory
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EJBComponentDescriptionFactory.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Skipping EJB annotation processing since no composite annotation index found in unit: " + deploymentUnit));
            }
        } else if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Skipping EJB annotation processing due to deployment being metadata-complete. ");
            }
        } else {
            this.processAnnotations(deploymentUnit, compositeIndex);
        }
        this.processDeploymentDescriptor(deploymentUnit);
    }

    protected void processDeploymentDescriptor(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return;
        }
        EnterpriseBeansMetaData ejbs = ejbJarMetaData.getEnterpriseBeans();
        if (ejbs != null && !ejbs.isEmpty()) {
            for (EnterpriseBeanMetaData ejb : ejbs) {
                this.processBeanMetaData(deploymentUnit, ejb);
            }
        }
        EjbDeploymentMarker.mark(deploymentUnit);
    }

    protected EjbJarDescription getEjbJarDescription(DeploymentUnit deploymentUnit) {
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (ejbJarDescription == null) {
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            ejbJarDescription = new EjbJarDescription(moduleDescription, applicationClassesDescription, deploymentUnit.getName().endsWith(".war"));
            deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION, (Object)ejbJarDescription);
        }
        return ejbJarDescription;
    }

    protected EnterpriseBeansMetaData getEnterpriseBeansMetaData(DeploymentUnit deploymentUnit) {
        EjbJarMetaData jarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (jarMetaData == null) {
            return null;
        }
        return jarMetaData.getEnterpriseBeans();
    }

    protected <B extends EnterpriseBeanMetaData> B getEnterpriseBeanMetaData(DeploymentUnit deploymentUnit, String name, Class<B> expectedType) {
        EnterpriseBeansMetaData enterpriseBeansMetaData = this.getEnterpriseBeansMetaData(deploymentUnit);
        if (enterpriseBeansMetaData == null) {
            return null;
        }
        return (B)((EnterpriseBeanMetaData)expectedType.cast(enterpriseBeansMetaData.get(name)));
    }

    protected abstract void processAnnotations(DeploymentUnit var1, CompositeIndex var2) throws DeploymentUnitProcessingException;

    protected abstract void processBeanMetaData(DeploymentUnit var1, EnterpriseBeanMetaData var2) throws DeploymentUnitProcessingException;

    protected static <T> T override(T original, T override) {
        return override != null ? override : original;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

