/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

public class InterceptorClassDeploymentDescriptorProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (ejbJarMetaData == null) {
            return;
        }
        if (!(ejbJarMetaData instanceof EjbJar3xMetaData)) {
            return;
        }
        EjbJar3xMetaData metaData = (EjbJar3xMetaData)ejbJarMetaData;
        if (metaData.getInterceptors() == null) {
            return;
        }
        for (InterceptorMetaData interceptor : metaData.getInterceptors()) {
            LifecycleCallbacksMetaData preDestroys;
            LifecycleCallbacksMetaData postConstructs;
            String interceptorClassName = interceptor.getInterceptorClass();
            EEModuleClassDescription interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptorClassName);
            AroundInvokesMetaData aroundInvokes = interceptor.getAroundInvokes();
            if (aroundInvokes != null) {
                for (AroundInvokeMetaData aroundInvoke : aroundInvokes) {
                    String methodName = aroundInvoke.getMethodName();
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Object.class, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                    interceptorModuleClassDescription.setAroundInvokeMethod(methodIdentifier);
                }
            }
            if ((postConstructs = interceptor.getPostConstructs()) != null) {
                for (LifecycleCallbackMetaData postConstruct : postConstructs) {
                    String methodName = postConstruct.getMethodName();
                    MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                    interceptorModuleClassDescription.setPostConstructMethod(methodIdentifier);
                }
            }
            if ((preDestroys = interceptor.getPreDestroys()) == null) continue;
            for (LifecycleCallbackMetaData preDestroy : preDestroys) {
                String methodName = preDestroy.getMethodName();
                MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifier(Void.TYPE, (String)methodName, (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setPreDestroyMethod(methodIdentifier);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

