/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.util.Collection;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.dd.AbstractEjbXmlDescriptorProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.javaee.spec.Environment;

public class SessionBeanXmlDescriptorProcessor
extends AbstractEjbXmlDescriptorProcessor<SessionBeanMetaData> {
    private static final Logger logger = Logger.getLogger(SessionBeanXmlDescriptorProcessor.class);

    @Override
    protected Class<SessionBeanMetaData> getMetaDataType() {
        return SessionBeanMetaData.class;
    }

    @Override
    protected void processBeanMetaData(SessionBeanMetaData sessionBean, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        BusinessRemotesMetaData businessRemotes;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String applicationName = moduleDescription.getApplicationName();
        String beanName = sessionBean.getName();
        SessionBeanComponentDescription sessionBeanDescription = (SessionBeanComponentDescription)moduleDescription.getComponentByName(beanName);
        sessionBeanDescription.setDeploymentDescriptorEnvironment(new DeploymentDescriptorEnvironment("java:comp/env/", (Environment)sessionBean));
        sessionBeanDescription.setMappedName(sessionBean.getMappedName());
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        if (businessLocals != null && !businessLocals.isEmpty()) {
            sessionBeanDescription.addLocalBusinessInterfaceViews((Collection<String>)businessLocals);
        }
        if ((businessRemotes = sessionBean.getBusinessRemotes()) != null && !businessRemotes.isEmpty()) {
            sessionBeanDescription.addRemoteBusinessInterfaceViews((Collection<String>)businessRemotes);
        }
        this.processInterceptors(sessionBean, sessionBeanDescription, applicationClassesDescription);
        if (sessionBean instanceof SessionBean31MetaData) {
            this.processSessionBean31((SessionBean31MetaData)sessionBean, sessionBeanDescription);
        }
    }

    protected void processInterceptors(SessionBeanMetaData enterpriseBean, EJBComponentDescription ejbComponentDescription, EEApplicationClasses applicationClassesDescription) {
        MethodIdentifier identifier;
        EEModuleClassDescription interceptorModuleClassDescription;
        if (enterpriseBean.getAroundInvokes() != null) {
            for (AroundInvokeMetaData interceptor : enterpriseBean.getAroundInvokes()) {
                if (interceptor.getClassName() == null) {
                    ejbComponentDescription.getAroundInvokeDDMethods().add(interceptor.getMethodName());
                    continue;
                }
                interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptor.getClassName());
                identifier = MethodIdentifier.getIdentifier(Object.class, (String)interceptor.getMethodName(), (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setAroundInvokeMethod(identifier);
            }
        }
        if (enterpriseBean.getPreDestroys() != null) {
            for (AroundInvokeMetaData interceptor : enterpriseBean.getPreDestroys()) {
                if (interceptor.getClassName() == null) {
                    ejbComponentDescription.getPreDestroyDDMethods().add(interceptor.getMethodName());
                    continue;
                }
                interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptor.getClassName());
                identifier = MethodIdentifier.getIdentifier(Object.class, (String)interceptor.getMethodName(), (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setPreDestroyMethod(identifier);
            }
        }
        if (enterpriseBean.getPostConstructs() != null) {
            for (AroundInvokeMetaData interceptor : enterpriseBean.getPostConstructs()) {
                if (interceptor.getClassName() == null) {
                    ejbComponentDescription.getPostConstructDDMethods().add(interceptor.getMethodName());
                    continue;
                }
                interceptorModuleClassDescription = applicationClassesDescription.getOrAddClassByName(interceptor.getClassName());
                identifier = MethodIdentifier.getIdentifier(Object.class, (String)interceptor.getMethodName(), (Class[])new Class[]{InvocationContext.class});
                interceptorModuleClassDescription.setPostConstructMethod(identifier);
            }
        }
    }

    private void processSessionBean31(SessionBean31MetaData sessionBean31MetaData, SessionBeanComponentDescription sessionBeanComponentDescription) {
        if (sessionBean31MetaData.isNoInterfaceBean()) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
    }
}

