/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.schedule.attribute;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.ejb3.timerservice.schedule.ScheduleExpressionTypeUtil;
import org.jboss.as.ejb3.timerservice.schedule.value.IncrementValue;
import org.jboss.as.ejb3.timerservice.schedule.value.ListValue;
import org.jboss.as.ejb3.timerservice.schedule.value.RangeValue;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleExpressionType;
import org.jboss.as.ejb3.timerservice.schedule.value.ScheduleValue;
import org.jboss.as.ejb3.timerservice.schedule.value.SingleValue;

public abstract class IntegerBasedExpression {
    protected final SortedSet<Integer> absoluteValues = new TreeSet<Integer>();
    protected final Set<ScheduleValue> relativeValues = new HashSet<ScheduleValue>();
    protected final ScheduleExpressionType scheduleExpressionType;
    protected final String origValue;

    protected abstract Integer getMaxValue();

    protected abstract Integer getMinValue();

    protected abstract boolean accepts(ScheduleExpressionType var1);

    public IntegerBasedExpression(String value) {
        this.origValue = value;
        this.scheduleExpressionType = ScheduleExpressionTypeUtil.getType(value);
        if (!this.accepts(this.scheduleExpressionType)) {
            throw new IllegalArgumentException("Invalid value: " + value + " since " + this.getClass().getName() + " doesn't support values of types " + this.scheduleExpressionType.toString());
        }
        switch (this.scheduleExpressionType) {
            case RANGE: {
                RangeValue range = new RangeValue(value);
                this.processRangeValue(range);
                break;
            }
            case LIST: {
                ListValue list = new ListValue(value);
                this.processListValue(list);
                break;
            }
            case INCREMENT: {
                IncrementValue incrValue = new IncrementValue(value);
                this.processIncrement(incrValue);
                break;
            }
            case SINGLE_VALUE: {
                SingleValue singleValue = new SingleValue(value);
                this.processSingleValue(singleValue);
                break;
            }
            case WILDCARD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for second: " + value);
            }
        }
    }

    protected void processListValue(ListValue list) {
        for (String listItem : list.getValues()) {
            this.processListItem(listItem);
        }
    }

    protected void processListItem(String listItem) {
        ScheduleExpressionType listItemType = ScheduleExpressionTypeUtil.getType(listItem);
        switch (listItemType) {
            case SINGLE_VALUE: {
                SingleValue singleVal = new SingleValue(listItem);
                this.processSingleValue(singleVal);
                return;
            }
            case RANGE: {
                RangeValue range = new RangeValue(listItem);
                this.processRangeValue(range);
                return;
            }
        }
        throw new IllegalArgumentException("A list value can only contain either a range or an individual value. Invalid value: " + listItem);
    }

    protected void processRangeValue(RangeValue range) {
        String start = range.getStart();
        String end = range.getEnd();
        if (this.isRelativeValue(start) || this.isRelativeValue(end)) {
            this.relativeValues.add(range);
            return;
        }
        Integer rangeStart = this.parseInt(start);
        Integer rangeEnd = this.parseInt(end);
        this.assertValid(rangeStart);
        this.assertValid(rangeEnd);
        if (rangeStart.equals(rangeEnd)) {
            this.absoluteValues.add(rangeStart);
            return;
        }
        if (rangeStart > rangeEnd) {
            int i;
            for (i = rangeStart.intValue(); i <= this.getMaxValue(); ++i) {
                this.absoluteValues.add(i);
            }
            for (i = this.getMinValue().intValue(); i <= rangeEnd; ++i) {
                this.absoluteValues.add(i);
            }
        } else {
            for (int i = rangeStart.intValue(); i <= rangeEnd; ++i) {
                this.absoluteValues.add(i);
            }
        }
    }

    protected void processIncrement(IncrementValue incr) {
        String startValue = incr.getStart();
        Integer start = startValue.equals("*") ? 0 : this.parseInt(startValue);
        this.assertValid(start);
        Integer interval = this.parseInt(incr.getInterval());
        this.absoluteValues.add(start);
        int maxValue = this.getMaxValue();
        for (int next = start + interval; next <= maxValue; next += interval.intValue()) {
            this.absoluteValues.add(next);
        }
    }

    protected void processSingleValue(SingleValue singleValue) {
        String value = singleValue.getValue();
        if (this.isRelativeValue(value)) {
            this.relativeValues.add(singleValue);
        } else {
            Integer val = this.parseInt(value);
            this.assertValid(val);
            this.absoluteValues.add(val);
        }
    }

    protected Integer parseInt(String alias) {
        if (alias == null) {
            return null;
        }
        return Integer.parseInt(alias.trim());
    }

    protected void assertValid(Integer value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Could not parse: " + this.origValue + " in schedule expression");
        }
        int max = this.getMaxValue();
        int min = this.getMinValue();
        if (value > max || value < min) {
            throw new IllegalArgumentException("Invalid value: " + value + " Valid values are between " + min + " and " + max);
        }
    }

    public abstract boolean isRelativeValue(String var1);
}

