/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import java.rmi.RemoteException;
import java.util.Random;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.TransactionAttributeType;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.context.spi.InvocationContext;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.ejb3.tx.TransactionalInvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.deadlock.ApplicationDeadlockException;

public class CMTTxInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(CMTTxInterceptor.class);
    private static final int MAX_RETRIES = 5;
    private static final Random RANDOM = new Random();
    private TransactionManager tm;

    protected void endTransaction(TransactionManager tm, Transaction tx) {
        try {
            if (tx != tm.getTransaction()) {
                throw new IllegalStateException("Wrong tx on thread: expected " + tx + ", actual " + tm.getTransaction());
            }
            if (tx.getStatus() == 1) {
                tm.rollback();
            } else {
                tm.commit();
            }
        }
        catch (RollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicMixedException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (HeuristicRollbackException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
        catch (SystemException e) {
            this.handleEndTransactionException((Exception)((Object)e));
        }
    }

    protected int getCurrentTransactionTimeout() throws SystemException {
        if (this.tm instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)this.tm).getTransactionTimeout();
        }
        return 0;
    }

    protected void handleEndTransactionException(Exception e) {
        if (e instanceof RollbackException) {
            throw new EJBTransactionRolledbackException("Transaction rolled back", e);
        }
        throw new EJBException(e);
    }

    protected void handleInCallerTx(TransactionalInvocationContext invocation, Throwable t, Transaction tx) throws Exception {
        ApplicationExceptionDetails ae = invocation.getApplicationException(t.getClass());
        if (ae != null) {
            if (ae.isRollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBTransactionRolledbackException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = new EJBTransactionRolledbackException("Unexpected Error");
                t.initCause(cause);
            } else if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
                if (t instanceof RuntimeException) {
                    t = new EJBTransactionRolledbackException(t.getMessage(), (Exception)t);
                } else {
                    throw (Exception)t;
                }
            }
        }
        this.setRollbackOnly(tx);
        log.error((Object)t);
        throw (Exception)t;
    }

    public void handleExceptionInOurTx(TransactionalInvocationContext invocation, Throwable t, Transaction tx) throws Exception {
        ApplicationExceptionDetails ae = invocation.getApplicationException(t.getClass());
        if (ae != null) {
            if (ae.isRollback()) {
                this.setRollbackOnly(tx);
            }
            throw (Exception)t;
        }
        if (!(t instanceof EJBException) && !(t instanceof RemoteException)) {
            if (t instanceof Error) {
                Throwable cause = t;
                t = new EJBException("Unexpected Error");
                t.initCause(cause);
            } else if (t instanceof RuntimeException) {
                t = new EJBException((Exception)t);
            } else {
                throw (Exception)t;
            }
        }
        this.setRollbackOnly(tx);
        throw (Exception)t;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        TransactionalInvocationContext invocation = (TransactionalInvocationContext)context.getPrivateData(InvocationContext.class);
        TransactionAttributeType attr = invocation.getTransactionAttribute();
        switch (attr) {
            case MANDATORY: {
                return this.mandatory(invocation);
            }
            case NEVER: {
                return this.never(invocation);
            }
            case NOT_SUPPORTED: {
                return this.notSupported(invocation);
            }
            case REQUIRED: {
                return this.required(invocation);
            }
            case REQUIRES_NEW: {
                return this.requiresNew(invocation);
            }
            case SUPPORTS: {
                return this.supports(invocation);
            }
        }
        throw new IllegalStateException("Unexpected tx attribute " + attr + " on " + invocation);
    }

    protected Object invokeInCallerTx(TransactionalInvocationContext invocation, Transaction tx) throws Exception {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            this.handleInCallerTx(invocation, t, tx);
            throw new RuntimeException("UNREACHABLE");
        }
    }

    protected Object invokeInNoTx(TransactionalInvocationContext invocation) throws Exception {
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInOurTx(TransactionalInvocationContext invocation, TransactionManager tm) throws Exception {
        for (int i = 0; i < 5; ++i) {
            tm.begin();
            Transaction tx = tm.getTransaction();
            try {
                Object object = invocation.proceed();
                this.endTransaction(tm, tx);
                return object;
            }
            catch (Throwable t) {
                try {
                    try {
                        this.handleExceptionInOurTx(invocation, t, tx);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.endTransaction(tm, tx);
                    }
                }
                catch (Exception ex) {
                    ApplicationDeadlockException deadlock = ApplicationDeadlockException.isADE((Throwable)ex);
                    if (deadlock != null) {
                        if (!deadlock.retryable() || i + 1 >= 5) {
                            throw deadlock;
                        }
                        log.warn((Object)(deadlock.getMessage() + " retrying " + (i + 1)));
                        Thread.sleep(RANDOM.nextInt(1 + i), RANDOM.nextInt(1000));
                        continue;
                    }
                    throw ex;
                }
            }
        }
        throw new RuntimeException("UNREACHABLE");
    }

    protected Object mandatory(TransactionalInvocationContext invocation) throws Exception {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            throw new EJBTransactionRequiredException("Transaction is required for invocation: " + invocation);
        }
        return this.invokeInCallerTx(invocation, tx);
    }

    protected Object never(TransactionalInvocationContext invocation) throws Exception {
        if (this.tm.getTransaction() != null) {
            throw new EJBException("Transaction present on server in Never call (EJB3 13.6.2.6)");
        }
        return this.invokeInNoTx(invocation);
    }

    protected Object notSupported(TransactionalInvocationContext invocation) throws Exception {
        Transaction tx = this.tm.getTransaction();
        if (tx != null) {
            this.tm.suspend();
            try {
                Object object = this.invokeInNoTx(invocation);
                return object;
            }
            catch (Exception e) {
                if (invocation.getApplicationException(e.getClass()) != null) {
                    throw e;
                }
                throw new EJBException(e);
            }
            finally {
                this.tm.resume(tx);
            }
        }
        return this.invokeInNoTx(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object required(TransactionalInvocationContext invocation) throws Exception {
        int oldTimeout = this.getCurrentTransactionTimeout();
        int timeout = invocation.getTransactionTimeout();
        try {
            Transaction tx;
            if (timeout != -1 && this.tm != null) {
                this.tm.setTransactionTimeout(timeout);
            }
            if ((tx = this.tm.getTransaction()) == null) {
                Object object = this.invokeInOurTx(invocation, this.tm);
                return object;
            }
            Object object = this.invokeInCallerTx(invocation, tx);
            return object;
        }
        finally {
            if (this.tm != null) {
                this.tm.setTransactionTimeout(oldTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object requiresNew(TransactionalInvocationContext invocation) throws Exception {
        int oldTimeout = this.getCurrentTransactionTimeout();
        int timeout = invocation.getTransactionTimeout();
        try {
            Transaction tx;
            if (timeout != -1 && this.tm != null) {
                this.tm.setTransactionTimeout(timeout);
            }
            if ((tx = this.tm.getTransaction()) != null) {
                this.tm.suspend();
                try {
                    Object object = this.invokeInOurTx(invocation, this.tm);
                    return object;
                }
                finally {
                    this.tm.resume(tx);
                }
            }
            Object object = this.invokeInOurTx(invocation, this.tm);
            return object;
        }
        finally {
            if (this.tm != null) {
                this.tm.setTransactionTimeout(oldTimeout);
            }
        }
    }

    protected void setRollbackOnly(Transaction tx) {
        try {
            tx.setRollbackOnly();
        }
        catch (SystemException ex) {
            log.error((Object)"SystemException while setting transaction for rollback only", (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            log.error((Object)"IllegalStateException while setting transaction for rollback only", (Throwable)ex);
        }
    }

    @Resource
    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    protected Object supports(TransactionalInvocationContext invocation) throws Exception {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            return this.invokeInNoTx(invocation);
        }
        return this.invokeInCallerTx(invocation, tx);
    }
}

