/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.ejb.client.SessionID;
import org.jboss.tm.TxUtils;

public class ExpiringCache<T extends Identifiable>
implements Cache<T> {
    private static final long SLEEP_TIME = 500L;
    private final long millisecondTimeout;
    private final String beanName;
    private final Map<SessionID, Entry> cache;
    private volatile StatefulObjectFactory<T> factory;
    private volatile ExpirationTask expiryThread;

    public ExpiringCache(long value, TimeUnit timeUnit, String beanName) {
        this.beanName = beanName;
        this.millisecondTimeout = TimeUnit.MILLISECONDS.convert(value, timeUnit);
        this.cache = new HashMap<SessionID, Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create() {
        Identifiable obj = (Identifiable)this.factory.createInstance();
        Entry entry = new Entry(this, obj);
        Map<SessionID, Entry> map = this.cache;
        synchronized (map) {
            this.cache.put(obj.getId(), entry);
        }
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(SessionID key) {
        Map<SessionID, Entry> map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(SessionID key) {
        Map<SessionID, Entry> map = this.cache;
        synchronized (map) {
            Entry val = this.cache.get(key);
            if (val == null) {
                return null;
            }
            val.lastUsed = System.currentTimeMillis();
            val.state = State.IN_USE;
            return val.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T obj) {
        Map<SessionID, Entry> map = this.cache;
        synchronized (map) {
            Entry entry = this.cache.get(obj.getId());
            if (entry == null) {
                EjbLogger.ROOT_LOGGER.couldNotFindStatefulBean(obj.getId());
                return;
            }
            entry.lastUsed = System.currentTimeMillis();
            entry.state = State.INACTIVE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TransactionManager transactionManager, SessionID key) {
        Entry object;
        Transaction currentTx;
        try {
            currentTx = transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        Map<SessionID, Entry> map = this.cache;
        synchronized (map) {
            object = this.cache.remove(key);
        }
        if (currentTx != null && TxUtils.isActive((Transaction)currentTx)) {
            try {
                currentTx.registerSynchronization((Synchronization)new RemoveSynchronization(object));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.factory.destroyInstance(object.value);
        }
    }

    @Override
    public void setStatefulObjectFactory(StatefulObjectFactory<T> tStatefulObjectFactory) {
        this.factory = tStatefulObjectFactory;
    }

    @Override
    public synchronized void start() {
        if (this.millisecondTimeout >= 0L) {
            this.expiryThread = new ExpirationTask();
            this.expiryThread.setDaemon(true);
            this.expiryThread.start();
            this.expiryThread.setName("Expiry Thread for SFSB " + this.beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (this.expiryThread != null) {
            this.expiryThread.stopTask();
        }
        Map<SessionID, Entry> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    private class RemoveSynchronization
    implements Synchronization {
        private final Entry object;

        public RemoveSynchronization(Entry object) {
            this.object = object;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ExpiringCache.this.factory.destroyInstance(this.object.value);
        }
    }

    private static final class Entry {
        private long lastUsed;
        private State state = State.IN_USE;
        private final T value;
        final /* synthetic */ ExpiringCache this$0;

        public Entry(T value) {
            this.this$0 = var1_1;
            this.value = value;
            this.lastUsed = System.currentTimeMillis();
        }

        public void setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        public SessionID getKey() {
            return this.value.getId();
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public boolean isExpired(long currentTimeInMillis) {
            return this.state == State.INACTIVE && currentTimeInMillis > this.lastUsed + this.this$0.millisecondTimeout;
        }

        public T getValue() {
            return this.value;
        }
    }

    private static enum State {
        IN_USE,
        INACTIVE;

    }

    private class ExpirationTask
    extends Thread {
        private volatile boolean running = true;

        private ExpirationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                ArrayList queue = new ArrayList();
                long time = System.currentTimeMillis();
                Map map = ExpiringCache.this.cache;
                synchronized (map) {
                    Iterator iterator = ExpiringCache.this.cache.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (!((Entry)entry.getValue()).isExpired(time)) continue;
                        queue.add(entry.getValue());
                        iterator.remove();
                    }
                }
                for (Entry value : queue) {
                    try {
                        EjbLogger.ROOT_LOGGER.debugf("Removing stateful bean %s - %s as it has been inactive for %d milliseconds", ExpiringCache.this.beanName, value.getKey(), ExpiringCache.this.millisecondTimeout);
                        ExpiringCache.this.factory.destroyInstance(value.getValue());
                    }
                    catch (Exception e) {
                        EjbLogger.ROOT_LOGGER.errorRemovingStatefulBean(value.getKey(), e);
                    }
                }
                try {
                    ExpirationTask.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.running = false;
                    return;
                }
            }
        }

        public void stopTask() {
            this.running = false;
        }
    }
}

