/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.NoSuchObjectLocalException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.logging.Logger;

public class StatefulComponentInstanceInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(StatefulComponentInstanceInterceptor.class);

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulComponentInstanceInterceptor.getComponent(context, StatefulSessionComponent.class);
        SessionID sessionId = (SessionID)context.getPrivateData((Object)SessionID.SESSION_ID_KEY);
        if (sessionId == null) {
            throw EjbMessages.MESSAGES.statefulSessionIdIsNull(component.getComponentName());
        }
        EjbLogger.ROOT_LOGGER.debug("Looking for stateful component instance with session id: " + sessionId);
        StatefulSessionComponentInstance instance = component.getCache().get(sessionId);
        if (instance == null) {
            ComponentView view = (ComponentView)context.getPrivateData(ComponentView.class);
            if (view.getViewClass() == component.getEjbLocalObjectType()) {
                throw new NoSuchObjectLocalException("Could not find SFSB " + component.getComponentName() + " with " + sessionId);
            }
            if (view.getViewClass() == component.getEjbObjectType()) {
                throw new NoSuchObjectException("Could not find SFSB " + component.getComponentName() + " with " + sessionId);
            }
            throw new NoSuchEJBException("Could not find SFSB " + component.getComponentName() + " with " + sessionId);
        }
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            Object view = context.proceed();
            return view;
        }
        catch (Exception ex) {
            if (component.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                    EjbLogger.ROOT_LOGGER.trace("Removing bean " + sessionId + " because of exception", ex);
                }
                component.getCache().discard(sessionId);
            }
            throw ex;
        }
        catch (Error e) {
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Removing bean " + sessionId + " because of error", e);
            }
            component.getCache().discard(sessionId);
            throw e;
        }
        catch (Throwable t) {
            if (EjbLogger.ROOT_LOGGER.isTraceEnabled()) {
                EjbLogger.ROOT_LOGGER.trace("Removing bean " + sessionId + " because of Throwable", t);
            }
            component.getCache().discard(sessionId);
            throw new RuntimeException(t);
        }
        finally {
            context.putPrivateData(ComponentInstance.class, null);
        }
    }

    static StatefulSessionComponentInstance getComponentInstance(InterceptorContext context) {
        return (StatefulSessionComponentInstance)context.getPrivateData(ComponentInstance.class);
    }

    public static class Factory
    implements InterceptorFactory {
        public static final InterceptorFactory INSTANCE = new Factory();

        private Factory() {
        }

        public Interceptor create(InterceptorFactoryContext context) {
            return new StatefulComponentInstanceInterceptor();
        }
    }
}

