/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

public class StatefulComponentSessionIdGeneratingInterceptorFactory
implements InterceptorFactory {
    public static final StatefulComponentSessionIdGeneratingInterceptorFactory INSTANCE = new StatefulComponentSessionIdGeneratingInterceptorFactory();

    private StatefulComponentSessionIdGeneratingInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference<SessionID> sessionIdReference = new AtomicReference<SessionID>();
        context.getContextData().put(StatefulSessionComponent.SESSION_ID_REFERENCE_KEY, sessionIdReference);
        SessionID id = (SessionID)context.getContextData().get(SessionID.SESSION_ID_KEY);
        if (id == null) {
            return new StatefulComponentSessionIdGeneratingInterceptor(sessionIdReference);
        }
        sessionIdReference.set(id);
        return Interceptors.getTerminalInterceptor();
    }

    private class StatefulComponentSessionIdGeneratingInterceptor
    implements Interceptor {
        private final AtomicReference<SessionID> sessionIdReference;

        StatefulComponentSessionIdGeneratingInterceptor(AtomicReference<SessionID> sessionIdReference) {
            this.sessionIdReference = sessionIdReference;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            Component component = (Component)context.getPrivateData(Component.class);
            if (!(component instanceof StatefulSessionComponent)) {
                throw EjbMessages.MESSAGES.unexpectedComponent(component, StatefulSessionComponent.class);
            }
            StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
            StatefulSessionComponentInstance statefulSessionComponentInstance = statefulComponent.getCache().create();
            this.sessionIdReference.set(statefulSessionComponentInstance.getId());
            return context.proceed();
        }
    }
}

