/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.Collection;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.iiop.EjbIIOPService;
import org.jboss.msc.value.InjectedValue;

public class EjbDeploymentInformation {
    private final String ejbName;
    private final ClassLoader deploymentClassLoader;
    private final InjectedValue<EJBComponent> ejbComponent;
    private final Map<String, InjectedValue<ComponentView>> componentViews;
    private final InjectedValue<EjbIIOPService> iorFactory;

    public EjbDeploymentInformation(String ejbName, InjectedValue<EJBComponent> ejbComponent, Map<String, InjectedValue<ComponentView>> componentViews, ClassLoader deploymentClassLoader, InjectedValue<EjbIIOPService> iorFactory) {
        this.ejbName = ejbName;
        this.ejbComponent = ejbComponent;
        this.componentViews = componentViews;
        this.deploymentClassLoader = deploymentClassLoader;
        this.iorFactory = iorFactory;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public EJBComponent getEjbComponent() {
        return (EJBComponent)((Object)this.ejbComponent.getValue());
    }

    public Collection<String> getViewNames() {
        return this.componentViews.keySet();
    }

    public ComponentView getView(String name) {
        InjectedValue<ComponentView> value = this.componentViews.get(name);
        if (value == null) {
            throw new IllegalArgumentException("View " + name + " was not found");
        }
        return (ComponentView)value.getValue();
    }

    public ClassLoader getDeploymentClassLoader() {
        return this.deploymentClassLoader;
    }

    public EjbIIOPService getIorFactory() {
        return (EjbIIOPService)this.iorFactory.getOptionalValue();
    }
}

