/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Timer;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.persistence.filestore.FileTimerPersistence;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class TimerServiceDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final ServiceName TIMER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "timer"});
    public static final ServiceName PATH_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "timerService", "dataPath"});
    private final ServiceName timerServiceThreadPool;

    public TimerServiceDeploymentProcessor(ServiceName timerServiceThreadPool) {
        this.timerServiceThreadPool = timerServiceThreadPool;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (final ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!component.isTimerServiceApplicable()) continue;
            EjbLogger.ROOT_LOGGER.debug("Installing timer service for component " + component.getComponentName());
            component.getConfigurators().add(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)description;
                    configuration.addTimeoutInterceptor(CurrentInvocationContextInterceptor.FACTORY, 784);
                    final ServiceName serviceName = component.getServiceName().append(TimerServiceImpl.SERVICE_NAME);
                    TimerServiceImpl service = new TimerServiceImpl(ejbComponentDescription.getScheduleMethods(), serviceName);
                    ServiceBuilder createBuilder = context.getServiceTarget().addService(serviceName, (Service)service);
                    createBuilder.addDependency(TIMER_SERVICE_NAME, Timer.class, service.getTimerInjectedValue());
                    createBuilder.addDependency(component.getCreateServiceName(), EJBComponent.class, service.getEjbComponentInjectedValue());
                    createBuilder.addDependency(TimerServiceDeploymentProcessor.this.timerServiceThreadPool, ExecutorService.class, service.getExecutorServiceInjectedValue());
                    createBuilder.addDependency(FileTimerPersistence.SERVICE_NAME, TimerPersistence.class, service.getTimerPersistence());
                    createBuilder.install();
                    ejbComponentDescription.setTimerService(service);
                    configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(serviceName);
                        }
                    });
                }
            });
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

