/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataOutput;
import java.io.IOException;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.ejb.client.remoting.PackedInteger;

class ModuleAvailabilityWriter {
    static final byte HEADER_MODULE_AVAILABLE = 8;
    static final byte HEADER_MODULE_UNAVAILABLE = 9;
    private final String marshallingStrategy;

    ModuleAvailabilityWriter(String marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    void writeModuleAvailability(DataOutput output, DeploymentModuleIdentifier[] availableModules) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null output");
        }
        if (availableModules == null) {
            throw new IllegalArgumentException("EJB module identifiers cannot be null");
        }
        output.write(8);
        this.writeModuleReport(output, availableModules);
    }

    void writeModuleUnAvailability(DataOutput output, DeploymentModuleIdentifier[] unavailableModules) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("Cannot write to null output");
        }
        if (unavailableModules == null) {
            throw new IllegalArgumentException("EJB module identifiers cannot be null");
        }
        output.write(9);
        this.writeModuleReport(output, unavailableModules);
    }

    private void writeModuleReport(DataOutput output, DeploymentModuleIdentifier[] modules) throws IOException {
        PackedInteger.writePackedInteger((DataOutput)output, (int)modules.length);
        for (int i = 0; i < modules.length; ++i) {
            String appName = modules[i].getApplicationName();
            if (appName == null) {
                output.writeUTF("");
            } else {
                output.writeUTF(appName);
            }
            output.writeUTF(modules[i].getModuleName());
            String distinctName = modules[i].getDistinctName();
            if (distinctName == null) {
                output.writeUTF("");
                continue;
            }
            output.writeUTF(distinctName);
        }
    }
}

