/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentDescription;

public class EJBMethodSecurityMetaData {
    private final boolean denyAll;
    private final boolean permitAll;
    private final Set<String> rolesAllowed;

    public EJBMethodSecurityMetaData(ComponentConfiguration componentConfiguration, String viewClassName, Method viewMethod) {
        if (!(componentConfiguration.getComponentDescription() instanceof EJBComponentDescription)) {
            throw EjbMessages.MESSAGES.invalidComponentIsNotEjbComponent(componentConfiguration.getComponentName());
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.denyAll = this.isAccessDenied(componentConfiguration, viewClassName, viewMethod);
        this.permitAll = this.isPermitAll(componentConfiguration, viewClassName, viewMethod);
        this.rolesAllowed = Collections.unmodifiableSet(this.getRolesAllowed(componentConfiguration, viewClassName, viewMethod));
    }

    public boolean isAccessDenied() {
        return this.denyAll;
    }

    public boolean isPermitAll() {
        return this.permitAll;
    }

    public Set<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    private boolean isAccessDenied(ComponentConfiguration componentConfiguration, String viewClassName, Method viewMethod) {
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        Method componentMethod = this.findComponentMethod(componentConfiguration, viewMethod);
        EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(componentMethod);
        Set<String> rolesAllowed = ejbComponentDescription.getRolesAllowed(viewClassName, ejbMethodIdentifier);
        boolean methodMarkedForDenyAll = this.isMethodMarkedForDenyAll(ejbComponentDescription, viewClassName, ejbMethodIdentifier);
        boolean methodMarkedForPermitAll = this.isMethodMarkedForPermitAll(ejbComponentDescription, viewClassName, ejbMethodIdentifier);
        if (methodMarkedForDenyAll) {
            if (methodMarkedForPermitAll) {
                throw EjbMessages.MESSAGES.invalidSecurityAnnotation(componentMethod, viewClassName, "@PemitAll", "@DenyAll");
            }
            if (!rolesAllowed.isEmpty()) {
                throw EjbMessages.MESSAGES.invalidSecurityAnnotation(componentMethod, viewClassName, "@RolesAllowed", "@DenyAll");
            }
            return true;
        }
        if (!rolesAllowed.isEmpty()) {
            return false;
        }
        if (methodMarkedForPermitAll) {
            return false;
        }
        Class<?> declaringClass = componentMethod.getDeclaringClass();
        return ejbComponentDescription.isDenyAllApplicableToClass(viewClassName, declaringClass.getName());
    }

    private boolean isPermitAll(ComponentConfiguration componentConfiguration, String viewClassName, Method viewMethod) {
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        Method componentMethod = this.findComponentMethod(componentConfiguration, viewMethod);
        EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(componentMethod);
        Set<String> rolesAllowed = ejbComponentDescription.getRolesAllowed(viewClassName, ejbMethodIdentifier);
        boolean methodMarkedForDenyAll = this.isMethodMarkedForDenyAll(ejbComponentDescription, viewClassName, ejbMethodIdentifier);
        boolean methodMarkedForPermitAll = this.isMethodMarkedForPermitAll(ejbComponentDescription, viewClassName, ejbMethodIdentifier);
        if (methodMarkedForPermitAll) {
            if (methodMarkedForDenyAll) {
                throw EjbMessages.MESSAGES.invalidSecurityAnnotation(componentMethod, viewClassName, "@PemitAll", "@DenyAll");
            }
            if (!rolesAllowed.isEmpty()) {
                throw EjbMessages.MESSAGES.invalidSecurityAnnotation(componentMethod, viewClassName, "@RolesAllowed", "@PermitAll");
            }
            return true;
        }
        if (!rolesAllowed.isEmpty()) {
            return false;
        }
        if (methodMarkedForPermitAll) {
            return false;
        }
        Class<?> declaringClass = componentMethod.getDeclaringClass();
        return ejbComponentDescription.isPermitAllApplicableToClass(viewClassName, declaringClass.getName());
    }

    private Set<String> getRolesAllowed(ComponentConfiguration componentConfiguration, String viewClassName, Method viewMethod) {
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        Method componentMethod = this.findComponentMethod(componentConfiguration, viewMethod);
        EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethod(componentMethod);
        Set<String> rolesAllowed = ejbComponentDescription.getRolesAllowed(viewClassName, ejbMethodIdentifier);
        boolean methodMarkedForDenyAll = this.isMethodMarkedForDenyAll(ejbComponentDescription, viewClassName, ejbMethodIdentifier);
        boolean methodMarkedForPermitAll = this.isMethodMarkedForPermitAll(ejbComponentDescription, viewClassName, ejbMethodIdentifier);
        if (!rolesAllowed.isEmpty()) {
            return rolesAllowed;
        }
        if (methodMarkedForDenyAll) {
            return Collections.emptySet();
        }
        if (methodMarkedForPermitAll) {
            return Collections.emptySet();
        }
        Class<?> declaringClass = componentMethod.getDeclaringClass();
        Set<String> classLevelRolesAllowed = ejbComponentDescription.getRolesAllowedForClass(viewClassName, declaringClass.getName());
        if (!classLevelRolesAllowed.isEmpty()) {
            return classLevelRolesAllowed;
        }
        return Collections.emptySet();
    }

    private boolean isMethodMarkedForDenyAll(EJBComponentDescription ejbComponentDescription, String viewClassName, EJBMethodIdentifier ejbMethodIdentifier) {
        Collection<EJBMethodIdentifier> denyAllMethodsForView = ejbComponentDescription.getDenyAllMethodsForView(viewClassName);
        return denyAllMethodsForView.contains(ejbMethodIdentifier);
    }

    private boolean isMethodMarkedForPermitAll(EJBComponentDescription ejbComponentDescription, String viewClassName, EJBMethodIdentifier ejbMethodIdentifier) {
        Collection<EJBMethodIdentifier> permitAllMethodsForView = ejbComponentDescription.getPermitAllMethodsForView(viewClassName);
        return permitAllMethodsForView.contains(ejbMethodIdentifier);
    }

    private Method findComponentMethod(ComponentConfiguration componentConfiguration, Method viewMethod) {
        Class componentClass = componentConfiguration.getComponentClass();
        try {
            return componentClass.getMethod(viewMethod.getName(), viewMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw EjbMessages.MESSAGES.failToFindComponentMethod(viewMethod.getName(), Arrays.toString(viewMethod.getParameterTypes()), componentClass);
        }
    }
}

