/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.subsystem.EJB3ThreadPoolResourceDefinition;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.TimeSpec;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class EJB3ThreadPoolAdd
extends AbstractBoottimeAddStepHandler {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"as", "ejb3", "threadPool"});
    private static final ServiceName THREAD_FACTORY_BASE_SERVICE_NAME = BASE_SERVICE_NAME.append(new String[]{"threadFactory"});
    static final EJB3ThreadPoolAdd INSTANCE = new EJB3ThreadPoolAdd();

    private EJB3ThreadPoolAdd() {
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        this.installRuntimeServices(context, name, model, verificationHandler, newControllers);
    }

    void installRuntimeServices(OperationContext context, String name, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Integer maxThreads = EJB3ThreadPoolResourceDefinition.MAX_THREADS.resolveModelAttribute(context, model).asInt(Runtime.getRuntime().availableProcessors());
        Integer keepAlive = EJB3ThreadPoolResourceDefinition.KEEPALIVE_TIME.resolveModelAttribute(context, model).asInt(0);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ThreadFactoryService threadFactory = new ThreadFactoryService();
        threadFactory.setThreadGroupName("EJB " + name);
        ServiceName threadFactoryServiceName = THREAD_FACTORY_BASE_SERVICE_NAME.append(new String[]{name});
        ServiceBuilder factoryBuilder = serviceTarget.addService(threadFactoryServiceName, (Service)threadFactory);
        if (verificationHandler != null) {
            factoryBuilder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(factoryBuilder.install());
        } else {
            factoryBuilder.install();
        }
        UnboundedQueueThreadPoolService service = new UnboundedQueueThreadPoolService(maxThreads.intValue(), new TimeSpec(TimeUnit.MILLISECONDS, (long)keepAlive.intValue()));
        ServiceBuilder builder = serviceTarget.addService(BASE_SERVICE_NAME.append(new String[]{name}), (Service)service).addDependency(threadFactoryServiceName, ThreadFactory.class, service.getThreadFactoryInjector()).setInitialMode(ServiceController.Mode.ACTIVE);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        if (newControllers != null) {
            newControllers.add(builder.install());
        } else {
            builder.install();
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        model.get("name").set(name);
        if (operation.hasDefined("keepalive-time")) {
            model.get("keepalive-time").set(operation.require("keepalive-time").asString());
        }
        if (operation.hasDefined("max-threads")) {
            model.get("max-threads").set(operation.require("max-threads").asString());
        }
    }
}

