/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.NamespaceConfigurator;
import org.jboss.as.ee.component.NamespaceViewConfigurator;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.PopulatingMap;
import org.jboss.as.ejb3.component.RemoteHomeViewInstanceFactory;
import org.jboss.as.ejb3.component.interceptors.EjbExceptionTransformingInterceptorFactory;
import org.jboss.as.ejb3.component.interceptors.LoggingInterceptor;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsViewConfigurator;
import org.jboss.as.ejb3.security.EJBSecurityViewConfigurator;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.timerservice.NonFunctionalTimerService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public abstract class EJBComponentDescription
extends ComponentDescription {
    private TransactionAttributeType beanTransactionAttribute = TransactionAttributeType.REQUIRED;
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private final Map<MethodIntf, TransactionAttributeType> txPerViewStyle1 = new HashMap<MethodIntf, TransactionAttributeType>();
    private EnterpriseBeanMetaData descriptorData;
    private String securityDomain;
    private final Set<String> declaredRoles = new HashSet<String>();
    private String runAsRole;
    private String runAsPrincipal;
    private SecurityRolesMetaData securityRoles;
    private final Map<String, Collection<EJBMethodIdentifier>> methodLevelDenyAll = new HashMap<String, Collection<EJBMethodIdentifier>>();
    private final Map<String, Collection<String>> classLevelDenyAll = new HashMap<String, Collection<String>>();
    private final Map<String, Map<EJBMethodIdentifier, Set<String>>> methodLevelRolesAllowed = new HashMap<String, Map<EJBMethodIdentifier, Set<String>>>();
    private final Map<String, Map<String, Set<String>>> classLevelRolesAllowed = new HashMap<String, Map<String, Set<String>>>();
    private final Map<String, Collection<String>> securityRoleLinks = new HashMap<String, Collection<String>>();
    private final Map<String, Collection<EJBMethodIdentifier>> methodLevelPermitAll = new HashMap<String, Collection<EJBMethodIdentifier>>();
    private final Map<String, Collection<String>> classLevelPermitAll = new HashMap<String, Collection<String>>();
    private final Map<Method, List<AutoTimer>> scheduleMethods = new IdentityHashMap<Method, List<AutoTimer>>();
    private Method timeoutMethod;
    private EJBViewDescription ejbLocalView;
    private EjbHomeViewDescription ejbLocalHomeView;
    private EJBViewDescription ejbRemoteView;
    private EjbHomeViewDescription ejbHomeView;
    private TimerService timerService = NonFunctionalTimerService.INSTANCE;
    private boolean exposedViaIiop = false;
    private final PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>> txPerViewStyle2 = new PopulatingMap<MethodIntf, Map<String, TransactionAttributeType>>(){

        @Override
        Map<String, TransactionAttributeType> populate() {
            return new HashMap<String, TransactionAttributeType>();
        }
    };
    private final PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>> txPerViewStyle3 = new PopulatingMap<MethodIntf, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>>(){

        @Override
        PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> populate() {
            return new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

                @Override
                Map<ArrayKey, TransactionAttributeType> populate() {
                    return new HashMap<ArrayKey, TransactionAttributeType>();
                }
            };
        }
    };
    private final Map<String, TransactionAttributeType> txStyle1 = new HashMap<String, TransactionAttributeType>();
    private final Map<String, TransactionAttributeType> txStyle2 = new HashMap<String, TransactionAttributeType>();
    private final PopulatingMap<String, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>> txStyle3 = new PopulatingMap<String, PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>>(){

        @Override
        PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>> populate() {
            return new PopulatingMap<String, Map<ArrayKey, TransactionAttributeType>>(){

                @Override
                Map<ArrayKey, TransactionAttributeType> populate() {
                    return new HashMap<ArrayKey, TransactionAttributeType>();
                }
            };
        }
    };

    public EJBComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription.getEEModuleDescription(), deploymentUnitServiceName);
        if (ejbJarDescription.isWar()) {
            this.setNamingMode(ComponentNamingMode.USE_MODULE);
        } else {
            this.setNamingMode(ComponentNamingMode.CREATE);
        }
        this.getConfigurators().addFirst(new NamespaceConfigurator());
        this.getConfigurators().add(new EjbJarConfigurationConfigurator());
        this.addDependency(EJBUtilities.SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
        this.addCurrentInvocationContextFactory();
        this.addRemoteTransactionsRepositoryDependency();
    }

    private static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public TransactionAttributeType getTransactionAttribute(MethodIntf methodIntf, String className, String methodName, String ... methodParams) {
        assert (methodIntf != null) : "methodIntf is null";
        assert (methodName != null) : "methodName is null";
        assert (methodParams != null) : "methodParams is null";
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        TransactionAttributeType txAttr = (TransactionAttributeType)EJBComponentDescription.get((Map)EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle3, methodIntf), methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(EJBComponentDescription.get(this.txPerViewStyle2, methodIntf), methodName);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txPerViewStyle1, methodIntf);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = (TransactionAttributeType)EJBComponentDescription.get((Map)EJBComponentDescription.get(EJBComponentDescription.get(this.txStyle3, className), methodName), methodParamsKey);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txStyle2, methodName);
        if (txAttr != null) {
            return txAttr;
        }
        txAttr = EJBComponentDescription.get(this.txStyle1, className);
        if (txAttr != null) {
            return txAttr;
        }
        return this.beanTransactionAttribute;
    }

    public void addLocalHome(String localHome) {
        EjbHomeViewDescription view = new EjbHomeViewDescription(this, localHome, MethodIntf.LOCAL_HOME);
        this.getViews().add(view);
        this.setupViewInterceptors(view);
        this.setupHomeViewInterceptors(view);
        this.setupClientViewInterceptors(view);
        this.ejbLocalHomeView = view;
    }

    public void addRemoteHome(String remoteHome) {
        EjbHomeViewDescription view = new EjbHomeViewDescription(this, remoteHome, MethodIntf.HOME);
        this.getViews().add(view);
        this.setupViewInterceptors(view);
        this.setupHomeViewInterceptors(view);
        this.setupClientViewInterceptors(view);
        this.ejbHomeView = view;
    }

    public void addEjbLocalObjectView(String viewClassName) {
        EJBViewDescription view;
        this.ejbLocalView = view = this.registerView(viewClassName, MethodIntf.LOCAL, true);
    }

    public void addEjbObjectView(String viewClassName) {
        EJBViewDescription view;
        this.ejbRemoteView = view = this.registerView(viewClassName, MethodIntf.REMOTE, true);
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionAttribute(MethodIntf methodIntf, String className, TransactionAttributeType transactionAttribute) {
        if (methodIntf != null && className != null) {
            throw EjbMessages.MESSAGES.bothMethodIntAndClassNameSet(this.getComponentName());
        }
        if (methodIntf == null) {
            this.txStyle1.put(className, transactionAttribute);
        } else {
            this.txPerViewStyle1.put(methodIntf, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String methodName) {
        if (methodIntf == null) {
            this.txStyle2.put(methodName, transactionAttribute);
        } else {
            this.txPerViewStyle2.pick(methodIntf).put(methodName, transactionAttribute);
        }
    }

    public void setTransactionAttribute(MethodIntf methodIntf, TransactionAttributeType transactionAttribute, String className, String methodName, String ... methodParams) {
        ArrayKey methodParamsKey = new ArrayKey(methodParams);
        if (methodIntf == null) {
            this.txStyle3.pick(className).pick(methodName).put(methodParamsKey, transactionAttribute);
        } else {
            this.txPerViewStyle3.pick(methodIntf).pick(methodName).put(methodParamsKey, transactionAttribute);
        }
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public String getEJBName() {
        return this.getComponentName();
    }

    public String getEJBClassName() {
        return this.getComponentClassName();
    }

    protected void setupViewInterceptors(EJBViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                viewConfiguration.addViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)LoggingInterceptor.INSTANCE), 0);
            }
        });
        this.addCurrentInvocationContextFactory(view);
        this.setupSecurityInterceptors(view);
        this.setupRemoteViewInterceptors(view);
        view.getConfigurators().addFirst(new NamespaceViewConfigurator());
    }

    private void setupRemoteViewInterceptors(EJBViewDescription view) {
        if (view.getMethodIntf() == MethodIntf.REMOTE || view.getMethodIntf() == MethodIntf.HOME) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    if (Remote.class.isAssignableFrom(configuration.getViewClass())) {
                        configuration.addViewInterceptor((InterceptorFactory)EjbExceptionTransformingInterceptorFactory.INSTANCE, 512);
                    }
                }
            });
            if (view.getMethodIntf() == MethodIntf.HOME) {
                view.getConfigurators().add(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        if (Remote.class.isAssignableFrom(configuration.getViewClass())) {
                            String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                            configuration.setViewInstanceFactory((ViewInstanceFactory)new RemoteHomeViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                        }
                    }
                });
            }
            view.getConfigurators().add(new EJBRemoteTransactionsViewConfigurator());
        }
    }

    private void setupHomeViewInterceptors(EjbHomeViewDescription ejbHomeViewDescription) {
        ejbHomeViewDescription.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                ClassLoader componentClassLoader = componentConfiguration.getModuleClassLoder();
                ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor(componentClassLoader));
                viewConfiguration.addViewInterceptor((InterceptorFactory)tcclInterceptorFactory, 1);
            }
        });
    }

    protected void setupClientViewInterceptors(ViewDescription view) {
        this.addToStringMethodInterceptor(view);
    }

    protected abstract void addCurrentInvocationContextFactory();

    protected abstract void addCurrentInvocationContextFactory(ViewDescription var1);

    protected void addRemoteTransactionsRepositoryDependency() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration componentConfiguration) throws DeploymentUnitProcessingException {
                if (this.hasRemoteView((EJBComponentDescription)description)) {
                    componentConfiguration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService ejbComponentCreateService) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(EJBRemoteTransactionsRepository.SERVICE_NAME, EJBRemoteTransactionsRepository.class, ejbComponentCreateService.getEJBRemoteTransactionsRepositoryInjector());
                        }
                    });
                }
            }

            private boolean hasRemoteView(EJBComponentDescription ejbComponentDescription) {
                Set views = ejbComponentDescription.getViews();
                for (ViewDescription view : views) {
                    MethodIntf viewType;
                    if (!(view instanceof EJBViewDescription) || (viewType = ((EJBViewDescription)view).getMethodIntf()) != MethodIntf.REMOTE && viewType != MethodIntf.HOME) continue;
                    return true;
                }
                return false;
            }
        });
    }

    protected void setupSecurityInterceptors(ViewDescription view) {
        view.getConfigurators().add(new EJBSecurityViewConfigurator());
    }

    private void addToStringMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                Method TO_STRING_METHOD;
                try {
                    TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new DeploymentUnitProcessingException((Throwable)nsme);
                }
                List methods = configuration.getProxyFactory().getCachedMethods();
                for (Method method : methods) {
                    if (!TO_STRING_METHOD.equals(method)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ToStringMethodInterceptor(EJBComponentDescription.this.getComponentName())), 256);
                    return;
                }
            }
        });
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean isStateless() {
        return false;
    }

    public void addDeclaredRoles(String ... roles) {
        this.declaredRoles.addAll(Arrays.asList(roles));
    }

    public void setDeclaredRoles(Collection<String> roles) {
        if (roles == null) {
            throw EjbMessages.MESSAGES.SecurityRolesIsNull();
        }
        this.declaredRoles.clear();
        this.declaredRoles.addAll(roles);
    }

    public Set<String> getDeclaredRoles() {
        return Collections.unmodifiableSet(this.declaredRoles);
    }

    public void setRunAs(String role) {
        this.runAsRole = role;
    }

    public String getRunAs() {
        return this.runAsRole;
    }

    public void setRunAsPrincipal(String principal) {
        this.runAsPrincipal = principal;
    }

    public String getRunAsPrincipal() {
        return this.runAsPrincipal;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public SecurityRolesMetaData getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void applyDenyAllOnAllViewsForClass(String className) {
        if (className == null || className.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.classnameIsNull(className);
        }
        for (ViewDescription view : this.getViews()) {
            Collection<String> denyAllClasses = this.classLevelDenyAll.get(view.getViewClassName());
            if (denyAllClasses == null) {
                denyAllClasses = new HashSet<String>();
                this.classLevelDenyAll.put(view.getViewClassName(), denyAllClasses);
            }
            denyAllClasses.add(className);
        }
    }

    public void applyDenyAllOnAllViewsForMethod(EJBMethodIdentifier ejbMethodIdentifier) {
        for (ViewDescription view : this.getViews()) {
            Collection<EJBMethodIdentifier> denyAllViewMethods = this.methodLevelDenyAll.get(view.getViewClassName());
            if (denyAllViewMethods == null) {
                denyAllViewMethods = new ArrayList<EJBMethodIdentifier>();
                this.methodLevelDenyAll.put(view.getViewClassName(), denyAllViewMethods);
            }
            denyAllViewMethods.add(ejbMethodIdentifier);
        }
    }

    public void applyDenyAllOnViewTypeForMethod(MethodIntf viewType, EJBMethodIdentifier ejbMethodIdentifier) {
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Collection<EJBMethodIdentifier> denyAllViewMethods = this.methodLevelDenyAll.get(view.getViewClassName());
            if (denyAllViewMethods == null) {
                denyAllViewMethods = new ArrayList<EJBMethodIdentifier>();
                this.methodLevelDenyAll.put(view.getViewClassName(), denyAllViewMethods);
            }
            denyAllViewMethods.add(ejbMethodIdentifier);
        }
    }

    public void applyDenyAllOnAllMethodsOfAllViews() {
        this.applyDenyAllOnAllViewsForClass(this.getEJBClassName());
    }

    public void applyDenyAllOnAllMethodsOfViewType(MethodIntf viewType) {
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Collection<String> denyAllApplicableClasses = this.classLevelDenyAll.get(ejbView.getViewClassName());
            if (denyAllApplicableClasses == null) {
                denyAllApplicableClasses = new HashSet<String>();
                this.classLevelDenyAll.put(ejbView.getViewClassName(), denyAllApplicableClasses);
            }
            denyAllApplicableClasses.add(this.getEJBClassName());
        }
    }

    public Collection<EJBMethodIdentifier> getDenyAllMethodsForView(String viewClassName) {
        Collection<EJBMethodIdentifier> denyAllMethods = this.methodLevelDenyAll.get(viewClassName);
        if (denyAllMethods != null) {
            return Collections.unmodifiableCollection(denyAllMethods);
        }
        return Collections.emptySet();
    }

    public boolean isDenyAllApplicableToClass(String viewClassName, String className) {
        Collection<String> denyAllApplicableClasses = this.classLevelDenyAll.get(viewClassName);
        if (denyAllApplicableClasses == null) {
            return false;
        }
        return denyAllApplicableClasses.contains(className);
    }

    public void setRolesAllowedOnAllViewsForClass(String className, Set<String> roles) {
        if (className == null || className.trim().isEmpty()) {
            EjbMessages.MESSAGES.classnameIsNull(className);
        }
        if (roles == null) {
            throw EjbMessages.MESSAGES.setRolesForClassIsNull(className);
        }
        for (ViewDescription view : this.getViews()) {
            Map<String, Set<String>> perViewRoles = this.classLevelRolesAllowed.get(view.getViewClassName());
            if (perViewRoles == null) {
                perViewRoles = new HashMap<String, Set<String>>();
                this.classLevelRolesAllowed.put(view.getViewClassName(), perViewRoles);
            }
            perViewRoles.put(className, roles);
        }
    }

    public void setRolesAllowedForAllMethodsOfAllViews(Set<String> roles) {
        this.setRolesAllowedOnAllViewsForClass(this.getEJBClassName(), roles);
    }

    public void setRolesAllowedOnAllViewsForMethod(EJBMethodIdentifier ejbMethodIdentifier, Set<String> roles) {
        if (ejbMethodIdentifier == null) {
            throw EjbMessages.MESSAGES.ejbMethodIsNull();
        }
        if (roles == null) {
            throw EjbMessages.MESSAGES.rolesIsNull(ejbMethodIdentifier);
        }
        for (ViewDescription view : this.getViews()) {
            Map<EJBMethodIdentifier, Set<String>> perViewMethodRoles = this.methodLevelRolesAllowed.get(view.getViewClassName());
            if (perViewMethodRoles == null) {
                perViewMethodRoles = new HashMap<EJBMethodIdentifier, Set<String>>();
                this.methodLevelRolesAllowed.put(view.getViewClassName(), perViewMethodRoles);
            }
            perViewMethodRoles.put(ejbMethodIdentifier, roles);
        }
    }

    public void setRolesAllowedForAllMethodsOnViewType(MethodIntf viewType, Set<String> roles) {
        if (roles == null) {
            throw EjbMessages.MESSAGES.rolesIsNullOnViewType(viewType);
        }
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Map<String, Set<String>> perViewRoles = this.classLevelRolesAllowed.get(view.getViewClassName());
            if (perViewRoles == null) {
                perViewRoles = new HashMap<String, Set<String>>();
                this.classLevelRolesAllowed.put(view.getViewClassName(), perViewRoles);
            }
            perViewRoles.put(view.getViewClassName(), roles);
        }
    }

    public void setRolesAllowedForMethodOnViewType(MethodIntf viewType, EJBMethodIdentifier ejbMethodIdentifier, Set<String> roles) {
        if (ejbMethodIdentifier == null) {
            throw EjbMessages.MESSAGES.ejbMethodIsNullForViewType(viewType);
        }
        if (roles == null) {
            throw EjbMessages.MESSAGES.rolesIsNullOnViewTypeAndMethod(viewType, ejbMethodIdentifier);
        }
        for (ViewDescription view : this.getViews()) {
            EJBViewDescription ejbView;
            if (!(view instanceof EJBViewDescription) || (ejbView = (EJBViewDescription)view).getMethodIntf() != viewType) continue;
            Map<EJBMethodIdentifier, Set<String>> perViewMethodRoles = this.methodLevelRolesAllowed.get(view.getViewClassName());
            if (perViewMethodRoles == null) {
                perViewMethodRoles = new HashMap<EJBMethodIdentifier, Set<String>>();
                this.methodLevelRolesAllowed.put(view.getViewClassName(), perViewMethodRoles);
            }
            perViewMethodRoles.put(ejbMethodIdentifier, roles);
        }
    }

    public Set<String> getRolesAllowed(String viewClassName, EJBMethodIdentifier method) {
        Map<EJBMethodIdentifier, Set<String>> methods = this.methodLevelRolesAllowed.get(viewClassName);
        if (methods == null || methods.get(method) == null) {
            return Collections.emptySet();
        }
        return methods.get(method);
    }

    public Map<EJBMethodIdentifier, Set<String>> getRolesAllowed(String viewClassName) {
        Map<EJBMethodIdentifier, Set<String>> methods = this.methodLevelRolesAllowed.get(viewClassName);
        if (methods == null) {
            return Collections.emptyMap();
        }
        return methods;
    }

    public Set<String> getRolesAllowedForClass(String viewClassName, String className) {
        Map<String, Set<String>> perClassRoles = this.classLevelRolesAllowed.get(viewClassName);
        if (perClassRoles == null || perClassRoles.get(className) == null) {
            return Collections.emptySet();
        }
        return perClassRoles.get(className);
    }

    public void linkSecurityRoles(String fromRole, String toRole) {
        if (fromRole == null || fromRole.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.failToLinkFromEmptySecurityRole(fromRole);
        }
        if (toRole == null || toRole.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.failToLinkToEmptySecurityRole(toRole);
        }
        Collection<String> roleLinks = this.securityRoleLinks.get(fromRole);
        if (roleLinks == null) {
            roleLinks = new HashSet<String>();
            this.securityRoleLinks.put(fromRole, roleLinks);
        }
        roleLinks.add(toRole);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodIntf viewType) {
        return this.registerView(viewClassName, viewType, false);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodIntf viewType, boolean ejb2xView) {
        EJBViewDescription viewDescription = new EJBViewDescription(this, viewClassName, viewType, ejb2xView);
        this.getViews().add(viewDescription);
        this.setupViewInterceptors(viewDescription);
        this.setupClientViewInterceptors(viewDescription);
        return viewDescription;
    }

    public Map<String, Collection<String>> getSecurityRoleLinks() {
        return Collections.unmodifiableMap(this.securityRoleLinks);
    }

    public void applyPermitAllOnAllViewsForClass(String className) {
        if (className == null || className.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.classnameIsNull(className);
        }
        for (ViewDescription view : this.getViews()) {
            Collection<String> permitAllClasses = this.classLevelPermitAll.get(view.getViewClassName());
            if (permitAllClasses == null) {
                permitAllClasses = new HashSet<String>();
                this.classLevelPermitAll.put(view.getViewClassName(), permitAllClasses);
            }
            permitAllClasses.add(className);
        }
    }

    public void applyPermitAllOnAllViewsForMethod(EJBMethodIdentifier ejbMethodIdentifier) {
        for (ViewDescription view : this.getViews()) {
            Collection<EJBMethodIdentifier> permitAllMethods = this.methodLevelPermitAll.get(view.getViewClassName());
            if (permitAllMethods == null) {
                permitAllMethods = new ArrayList<EJBMethodIdentifier>();
                this.methodLevelPermitAll.put(view.getViewClassName(), permitAllMethods);
            }
            permitAllMethods.add(ejbMethodIdentifier);
        }
    }

    public Collection<EJBMethodIdentifier> getPermitAllMethodsForView(String viewClassName) {
        Collection<EJBMethodIdentifier> permitAllMethods = this.methodLevelPermitAll.get(viewClassName);
        if (permitAllMethods != null) {
            return Collections.unmodifiableCollection(permitAllMethods);
        }
        return Collections.emptySet();
    }

    public boolean isPermitAllApplicableToClass(String viewClassName, String className) {
        Collection<String> permitAllApplicationClasses = this.classLevelPermitAll.get(viewClassName);
        if (permitAllApplicationClasses == null) {
            return false;
        }
        return permitAllApplicationClasses.contains(className);
    }

    public boolean isSecurityEnabled() {
        return this.securityDomain != null;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public EnterpriseBeanMetaData getDescriptorData() {
        return this.descriptorData;
    }

    public void setDescriptorData(EnterpriseBeanMetaData descriptorData) {
        this.descriptorData = descriptorData;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public void setTimeoutMethod(Method timeoutMethod) {
        this.timeoutMethod = timeoutMethod;
    }

    public Map<Method, List<AutoTimer>> getScheduleMethods() {
        return Collections.unmodifiableMap(this.scheduleMethods);
    }

    public void addScheduleMethod(Method method, AutoTimer timer) {
        List<AutoTimer> schedules = this.scheduleMethods.get(method);
        if (schedules == null) {
            schedules = new ArrayList<AutoTimer>(1);
            this.scheduleMethods.put(method, schedules);
        }
        schedules.add(timer);
    }

    public EJBViewDescription getEjbLocalView() {
        return this.ejbLocalView;
    }

    public EjbHomeViewDescription getEjbLocalHomeView() {
        return this.ejbLocalHomeView;
    }

    public EjbHomeViewDescription getEjbHomeView() {
        return this.ejbHomeView;
    }

    public EJBViewDescription getEjbRemoteView() {
        return this.ejbRemoteView;
    }

    public boolean isExposedViaIiop() {
        return this.exposedViaIiop;
    }

    public void setExposedViaIiop(boolean exposedViaIiop) {
        this.exposedViaIiop = exposedViaIiop;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{" + "serviceName=" + this.getServiceName() + '}' + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private static class ToStringMethodInterceptor
    implements Interceptor {
        private final String name;

        public ToStringMethodInterceptor(String name) {
            this.name = name;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
            if (componentView == null) {
                throw EjbMessages.MESSAGES.componentViewNotAvailableInContext(context);
            }
            return "Proxy for view class: " + componentView.getViewClass().getName() + " of EJB: " + this.name;
        }
    }

    private class EjbJarConfigurationConfigurator
    implements ComponentConfigurator {
        private EjbJarConfigurationConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            ApplicationExceptions appExceptions = (ApplicationExceptions)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DETAILS);
            if (appExceptions == null) {
                throw EjbMessages.MESSAGES.ejbJarConfigNotFound(deploymentUnit);
            }
            EJBComponentCreateServiceFactory ejbComponentCreateServiceFactory = (EJBComponentCreateServiceFactory)configuration.getComponentCreateServiceFactory();
            ejbComponentCreateServiceFactory.setEjbJarConfiguration(appExceptions);
        }
    }
}

