/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.beans.IntrospectionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.inflow.EndpointDeployer;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.MessageListener;
import org.jboss.jca.core.spi.rar.NotFoundException;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.util.propertyeditor.PropertyEditors;

public class EJBUtilities
implements EndpointDeployer,
Service<EJBUtilities> {
    private static final Map<String, String> knownRar = new HashMap<String, String>(1);
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb", "utilities"});
    private final InjectedValue<MetadataRepository> mdrValue = new InjectedValue();
    private final InjectedValue<ResourceAdapterRepository> resourceAdapterRepositoryValue = new InjectedValue();
    private final InjectedValue<SimpleSecurityManager> securityManagerValue = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManagerValue = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistryValue = new InjectedValue();
    private final InjectedValue<UserTransaction> userTransactionValue = new InjectedValue();

    @Override
    public ActivationSpec createActivationSpecs(String resourceAdapterName, Class<?> messageListenerInterface, Properties activationConfigProperties, ClassLoader classLoader) {
        try {
            ActivationSpec activationSpec = null;
            boolean raFound = false;
            String packageName = knownRar.get(resourceAdapterName);
            if (packageName != null) {
                raFound = true;
            }
            if (!raFound) {
                for (String id : this.getMdr().getResourceAdapters()) {
                    if (!id.equals(resourceAdapterName)) continue;
                    if (!raFound) {
                        ResourceAdapter ra = this.getMdr().getResourceAdapter(id).getResourceadapter();
                        if (!(ra instanceof ResourceAdapter1516) || ((ResourceAdapter1516)ra).getInboundResourceadapter() == null) continue;
                        String className = ((ResourceAdapter1516)ra).getResourceadapterClass();
                        packageName = className.lastIndexOf(".") != -1 ? className.substring(0, className.lastIndexOf(".")) : "";
                        raFound = true;
                        EjbLogger.EJB3_LOGGER.debug("Found resource adapter class: " + className + " for resource-adapter-name: " + resourceAdapterName);
                        continue;
                    }
                    throw EjbMessages.MESSAGES.multipleResourceAdapterRegistered(resourceAdapterName);
                }
            }
            if (!raFound) {
                throw EjbMessages.MESSAGES.failToRegisteredResourceAdapter(resourceAdapterName);
            }
            Set ids = this.getResourceAdapterRepository().getResourceAdapters(messageListenerInterface);
            List listeners = null;
            boolean found = false;
            for (String id : ids) {
                if (!id.startsWith(packageName)) continue;
                if (!found) {
                    listeners = this.getResourceAdapterRepository().getMessageListeners(id);
                    found = true;
                    continue;
                }
                throw EjbMessages.MESSAGES.multipleResourceAdapterRegistered(resourceAdapterName);
            }
            if (found) {
                MessageListener messageListener = (MessageListener)listeners.get(0);
                Activation activation = messageListener.getActivation();
                Properties validActivationConfigProps = this.filterUnknownActivationConfigProperties(resourceAdapterName, activation, activationConfigProperties);
                activationSpec = activation.createInstance();
                PropertyEditors.mapJavaBeanProperties((Object)activationSpec, (Properties)validActivationConfigProps);
            }
            return activationSpec;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (org.jboss.jca.core.spi.mdr.NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataRepository getMdr() {
        return (MetadataRepository)this.mdrValue.getOptionalValue();
    }

    public Injector<MetadataRepository> getMdrInjector() {
        return this.mdrValue;
    }

    public ResourceAdapterRepository getResourceAdapterRepository() {
        return (ResourceAdapterRepository)this.resourceAdapterRepositoryValue.getOptionalValue();
    }

    public Injector<ResourceAdapterRepository> getResourceAdapterRepositoryInjector() {
        return this.resourceAdapterRepositoryValue;
    }

    public SimpleSecurityManager getSecurityManager() {
        SimpleSecurityManager securityManager = (SimpleSecurityManager)this.securityManagerValue.getOptionalValue();
        if (securityManager == null) {
            throw EjbMessages.MESSAGES.securityNotEnabled();
        }
        return securityManager;
    }

    public Injector<SimpleSecurityManager> getSecurityManagerInjector() {
        return this.securityManagerValue;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.transactionManagerValue.getOptionalValue();
    }

    public Injector<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManagerValue;
    }

    public InjectedValue<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
        return this.transactionSynchronizationRegistryValue;
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistryValue.getOptionalValue();
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)this.userTransactionValue.getOptionalValue();
    }

    public Injector<UserTransaction> getUserTransactionInjector() {
        return this.userTransactionValue;
    }

    public EJBUtilities getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public boolean hasSecurityManager() {
        return this.securityManagerValue.getOptionalValue() != null;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    private Properties filterUnknownActivationConfigProperties(String resourceAdapterName, Activation activation, Properties activationConfigProps) {
        if (activationConfigProps == null) {
            return null;
        }
        Map raActivationConfigProps = activation.getConfigProperties();
        Set raRequiredConfigProps = activation.getRequiredConfigProperties();
        Enumeration<?> propNames = activationConfigProps.propertyNames();
        Properties validActivationConfigProps = new Properties();
        validActivationConfigProps.putAll((Map<?, ?>)activationConfigProps);
        while (propNames.hasMoreElements()) {
            Object propName = propNames.nextElement();
            if (raActivationConfigProps.containsKey(propName) || raRequiredConfigProps.contains(propName)) continue;
            validActivationConfigProps.remove(propName);
            EjbLogger.EJB3_LOGGER.activationConfigPropertyIgnored(propName, resourceAdapterName);
        }
        return validActivationConfigProps;
    }

    static {
        knownRar.put("hornetq-ra", "org.hornetq.ra");
        knownRar.put("hornetq-ra.rar", "org.hornetq.ra");
    }
}

