/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.entitycache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.NoSuchEJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;
import org.jboss.logging.Logger;

public class TransactionLocalEntityCache
implements ReadyEntityCache {
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final ConcurrentMap<Object, Map<Object, EntityBeanComponentInstance>> cache = new ConcurrentHashMap<Object, Map<Object, EntityBeanComponentInstance>>(Runtime.getRuntime().availableProcessors());
    private final EntityBeanComponent component;
    private static final Logger logger = Logger.getLogger(TransactionLocalEntityCache.class);

    public TransactionLocalEntityCache(EntityBeanComponent component) {
        this.component = component;
        this.transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
    }

    @Override
    public EntityBeanComponentInstance get(Object key) throws NoSuchEJBException {
        if (!this.isTransactionActive()) {
            return this.createInstance(key);
        }
        Map<Object, EntityBeanComponentInstance> map = this.prepareCache();
        EntityBeanComponentInstance instance = map.get(key);
        if (instance == null) {
            instance = this.createInstance(key);
            map.put(key, instance);
        }
        return instance;
    }

    @Override
    public void discard(EntityBeanComponentInstance instance) {
        Object key;
        Map map;
        if (this.isTransactionActive() && (map = (Map)this.cache.get(key = this.transactionSynchronizationRegistry.getTransactionKey())) != null) {
            map.remove(instance.getPrimaryKey());
        }
        instance.discard();
    }

    @Override
    public void create(EntityBeanComponentInstance instance) throws NoSuchEJBException {
        if (this.isTransactionActive()) {
            Map<Object, EntityBeanComponentInstance> map = this.prepareCache();
            map.put(instance.getPrimaryKey(), instance);
        }
    }

    @Override
    public void release(EntityBeanComponentInstance instance, boolean success) {
        if (!success && instance.isRemoved()) {
            instance.setRemoved(false);
        }
        instance.passivate();
        this.component.getPool().release(instance);
        this.discard(instance);
    }

    @Override
    public void reference(EntityBeanComponentInstance instance) {
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
    }

    private Map<Object, EntityBeanComponentInstance> prepareCache() {
        final Object key = this.transactionSynchronizationRegistry.getTransactionKey();
        Map<Object, EntityBeanComponentInstance> map = (Map<Object, EntityBeanComponentInstance>)this.cache.get(key);
        if (map != null) {
            return map;
        }
        map = Collections.synchronizedMap(new HashMap());
        Map existing = this.cache.putIfAbsent(key, map);
        if (existing != null) {
            map = existing;
        }
        this.transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                TransactionLocalEntityCache.this.cache.remove(key);
            }
        });
        return map;
    }

    private EntityBeanComponentInstance createInstance(Object pk) {
        EntityBeanComponentInstance instance = this.component.getPool().get();
        instance.associate(pk);
        return instance;
    }

    private boolean isTransactionActive() {
        return this.transactionSynchronizationRegistry.getTransactionKey() != null;
    }
}

