/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.context;

import java.security.Principal;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.interceptors.DependencyInjectionCompleteMarker;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.context.EJBContextImpl;
import org.jboss.invocation.InterceptorContext;

public class SessionContextImpl
extends EJBContextImpl
implements SessionContext {
    private static final long serialVersionUID = 1L;
    private final boolean stateful;

    public SessionContextImpl(SessionBeanComponentInstance instance) {
        super(instance);
        this.stateful = instance.getComponent() instanceof StatefulSessionComponent;
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        return this.getComponent().getBusinessObject(businessInterface, invocation);
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        return this.getComponent().getEJBLocalObject(invocation);
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        return this.getComponent().getEJBObject(invocation);
    }

    public Class<?> getInvokedBusinessInterface() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        ComponentView view = (ComponentView)invocation.getPrivateData(ComponentView.class);
        if (view.getViewClass().equals(this.getComponent().getEjbObjectType()) || view.getViewClass().equals(this.getComponent().getEjbLocalObjectType())) {
            throw EjbMessages.MESSAGES.cannotCall("getInvokedBusinessInterface", "EjbObject", "EJBLocalObject");
        }
        return view.getViewClass();
    }

    @Override
    public SessionBeanComponent getComponent() {
        return (SessionBeanComponent)super.getComponent();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        MessageContext context = (MessageContext)invocation.getPrivateData(MessageContext.class);
        if (context == null) {
            throw EjbMessages.MESSAGES.cannotCall("getMessageContext()", "MessageContext");
        }
        return context;
    }

    public boolean wasCancelCalled() throws IllegalStateException {
        InterceptorContext invocation = CurrentInvocationContext.get();
        CancellationFlag flag = (CancellationFlag)invocation.getPrivateData(CancellationFlag.class);
        return flag.get();
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        boolean lifecycleCallback;
        InterceptorContext invocation = CurrentInvocationContext.get();
        boolean bl = lifecycleCallback = invocation.getMethod() == null;
        if (lifecycleCallback && !DependencyInjectionCompleteMarker.isDependencyInjectionComplete((InterceptorContext)invocation)) {
            throw EjbMessages.MESSAGES.callMethodNotAllowWhenDependencyInjectionInProgress("getTimerService()");
        }
        if (this.stateful) {
            throw EjbMessages.MESSAGES.notAllowedFromStatefulBeans("getTimerService()");
        }
        return super.getTimerService();
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        boolean lifecycleCallback;
        InterceptorContext invocation = CurrentInvocationContext.get();
        boolean bl = lifecycleCallback = invocation.getMethod() == null;
        if (lifecycleCallback && !DependencyInjectionCompleteMarker.isDependencyInjectionComplete((InterceptorContext)invocation)) {
            throw EjbMessages.MESSAGES.callMethodNotAllowWhenDependencyInjectionInProgress("getTimerService()");
        }
        return this.getComponent().getUserTransaction();
    }

    @Override
    public boolean isCallerInRole(String roleName) {
        boolean lifecycleCallback;
        InterceptorContext invocation = CurrentInvocationContext.get();
        boolean bl = lifecycleCallback = invocation.getMethod() == null;
        if (!(!lifecycleCallback || this.stateful && DependencyInjectionCompleteMarker.isDependencyInjectionComplete((InterceptorContext)invocation))) {
            throw EjbMessages.MESSAGES.lifecycleMethodNotAllowedFromStatelessSessionBean("isCallerInRole");
        }
        return super.isCallerInRole(roleName);
    }

    @Override
    public Principal getCallerPrincipal() {
        boolean lifecycleCallback;
        InterceptorContext invocation = CurrentInvocationContext.get();
        boolean bl = lifecycleCallback = invocation.getMethod() == null;
        if (!(!lifecycleCallback || this.stateful && DependencyInjectionCompleteMarker.isDependencyInjectionComplete((InterceptorContext)invocation))) {
            throw EjbMessages.MESSAGES.lifecycleMethodNotAllowedFromStatelessSessionBean("getCallerPrincipal");
        }
        return super.getCallerPrincipal();
    }
}

