/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;

public class MethodResolutionUtils {
    public static Method resolveMethod(NamedMethodMetaData methodData, Class<?> componentClass, DeploymentReflectionIndex reflectionIndex) throws DeploymentUnitProcessingException {
        return MethodResolutionUtils.resolveMethod(methodData.getMethodName(), methodData.getMethodParams(), componentClass, reflectionIndex);
    }

    public static Method resolveMethod(MethodMetaData methodData, Class<?> componentClass, DeploymentReflectionIndex reflectionIndex) throws DeploymentUnitProcessingException {
        return MethodResolutionUtils.resolveMethod(methodData.getMethodName(), methodData.getMethodParams(), componentClass, reflectionIndex);
    }

    public static Collection<Method> resolveMethods(NamedMethodMetaData methodData, Class<?> componentClass, DeploymentReflectionIndex reflectionIndex) throws DeploymentUnitProcessingException {
        return MethodResolutionUtils.resolveMethods(methodData.getMethodName(), methodData.getMethodParams(), componentClass, reflectionIndex);
    }

    public static Method resolveMethod(String methodName, MethodParametersMetaData parameters, Class<?> componentClass, DeploymentReflectionIndex reflectionIndex) throws DeploymentUnitProcessingException {
        Collection<Method> method = MethodResolutionUtils.resolveMethods(methodName, parameters, componentClass, reflectionIndex);
        if (method.size() > 1) {
            throw new DeploymentUnitProcessingException("More than one method found with name " + methodName + " on " + componentClass);
        }
        return method.iterator().next();
    }

    public static Collection<Method> resolveMethods(String methodName, MethodParametersMetaData parameters, Class<?> componentClass, DeploymentReflectionIndex reflectionIndex) throws DeploymentUnitProcessingException {
        for (Class<?> clazz = componentClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            Collection methods;
            ClassReflectionIndex classIndex = reflectionIndex.getClassIndex(clazz);
            if (parameters == null) {
                methods = classIndex.getAllMethods(methodName);
                if (methods.isEmpty()) continue;
                return methods;
            }
            methods = classIndex.getAllMethods(methodName, parameters.size());
            for (Method method : methods) {
                boolean match = true;
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    if (method.getParameterTypes()[i].getName().equals(parameters.get(i))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return Collections.singleton(method);
            }
        }
        throw EjbMessages.MESSAGES.failToFindMethodInEjbJarXml(componentClass.getName(), methodName);
    }
}

