/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.remote.SecurityActions;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class RemoteViewManagedReferenceFactory
implements ManagedReferenceFactory {
    private final String appName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;
    private final String viewClass;
    private final boolean stateful;

    public RemoteViewManagedReferenceFactory(String appName, String moduleName, String distinctName, String beanName, String viewClass, boolean stateful) {
        this.appName = appName == null ? "" : appName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
        this.viewClass = viewClass;
        this.stateful = stateful;
    }

    public ManagedReference getReference() {
        Class<?> viewClass;
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            viewClass = Class.forName(this.viewClass, false, tccl);
        }
        catch (ClassNotFoundException e) {
            throw EjbMessages.MESSAGES.failToLoadViewClassEjb(this.beanName, e);
        }
        Object ejbLocator = null;
        if (this.stateful) {
            SessionID sessionID;
            try {
                sessionID = EJBClient.createSession((String)this.appName, (String)this.moduleName, (String)this.beanName, (String)this.distinctName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ejbLocator = new StatefulEJBLocator(viewClass, this.appName, this.moduleName, this.beanName, this.distinctName, sessionID);
        } else {
            ejbLocator = EJBHome.class.isAssignableFrom(viewClass) || EJBLocalHome.class.isAssignableFrom(viewClass) ? new EJBHomeLocator(viewClass, this.appName, this.moduleName, this.beanName, this.distinctName) : new StatelessEJBLocator(viewClass, this.appName, this.moduleName, this.beanName, this.distinctName);
        }
        Object proxy = EJBClient.createProxy((EJBLocator)ejbLocator);
        return new ValueManagedReference((Value)new ImmediateValue(proxy));
    }
}

