/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.DeploymentRepositoryListener;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.MethodInvocationMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.ModuleAvailabilityWriter;
import org.jboss.as.ejb3.remote.protocol.versionone.SessionOpenRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

public class VersionOneProtocolChannelReceiver
implements Channel.Receiver,
DeploymentRepositoryListener {
    private static final Logger logger = Logger.getLogger(VersionOneProtocolChannelReceiver.class);
    private static final byte HEADER_SESSION_OPEN_REQUEST = 1;
    private static final byte HEADER_INVOCATION_REQUEST = 3;
    private static final byte HEADER_TX_COMMIT_REQUEST = 15;
    private static final byte HEADER_TX_ROLLBACK_REQUEST = 16;
    private static final byte HEADER_TX_PREPARE_REQUEST = 17;
    private static final byte HEADER_TX_FORGET_REQUEST = 18;
    private static final byte HEADER_TX_BEFORE_COMPLETION_REQUEST = 19;
    private final Channel channel;
    private final DeploymentRepository deploymentRepository;
    private final EJBRemoteTransactionsRepository transactionsRepository;
    private final String marshallingStrategy;
    private final ExecutorService executorService;

    public VersionOneProtocolChannelReceiver(Channel channel, DeploymentRepository deploymentRepository, EJBRemoteTransactionsRepository transactionsRepository, String marshallingStrategy, ExecutorService executorService) {
        this.marshallingStrategy = marshallingStrategy;
        this.channel = channel;
        this.executorService = executorService;
        this.deploymentRepository = deploymentRepository;
        this.transactionsRepository = transactionsRepository;
    }

    public void startReceiving() {
        this.channel.addCloseHandler((CloseHandler)new ChannelCloseHandler());
        this.channel.receiveMessage((Channel.Receiver)this);
        this.deploymentRepository.addListener(this);
    }

    public void handleError(Channel channel, IOException error) {
        try {
            channel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.deploymentRepository.removeListener(this);
        }
        throw new RuntimeException("NYI: .handleError");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEnd(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.deploymentRepository.removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
        try {
            int header = messageInputStream.read();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Got message with header 0x" + Integer.toHexString(header) + " on channel " + channel));
            }
            AbstractMessageHandler messageHandler = null;
            switch (header) {
                case 3: {
                    messageHandler = new MethodInvocationMessageHandler(this.deploymentRepository, this.marshallingStrategy, this.executorService);
                    break;
                }
                case 1: {
                    messageHandler = new SessionOpenRequestHandler(this.deploymentRepository, this.marshallingStrategy, this.executorService);
                    break;
                }
                case 15: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.executorService, TransactionRequestHandler.TransactionRequestType.COMMIT, this.marshallingStrategy);
                    break;
                }
                case 16: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.executorService, TransactionRequestHandler.TransactionRequestType.ROLLBACK, this.marshallingStrategy);
                    break;
                }
                case 18: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.executorService, TransactionRequestHandler.TransactionRequestType.FORGET, this.marshallingStrategy);
                    break;
                }
                case 17: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.executorService, TransactionRequestHandler.TransactionRequestType.PREPARE, this.marshallingStrategy);
                    break;
                }
                case 19: {
                    messageHandler = new TransactionRequestHandler(this.transactionsRepository, this.executorService, TransactionRequestHandler.TransactionRequestType.BEFORE_COMPLETION, this.marshallingStrategy);
                    break;
                }
                default: {
                    logger.warn((Object)("Received unsupported message header 0x" + Integer.toHexString(header) + " on channel " + channel));
                    return;
                }
            }
            messageHandler.processMessage(channel, messageInputStream);
            channel.receiveMessage((Channel.Receiver)this);
        }
        catch (IOException e) {
            logger.errorf((Throwable)e, "Exception on channel %s from message %s", (Object)channel, (Object)messageInputStream);
            IoUtils.safeClose((Closeable)channel);
        }
        finally {
            IoUtils.safeClose((Closeable)messageInputStream);
        }
    }

    @Override
    public void listenerAdded(DeploymentRepository repository) {
        Map<DeploymentModuleIdentifier, ModuleDeployment> availableModules = this.deploymentRepository.getModules();
        if (availableModules != null && !availableModules.isEmpty()) {
            try {
                logger.debug((Object)("Sending initial module availabilty message, containing " + availableModules.size() + " module(s) to channel " + this.channel));
                this.sendModuleAvailability(availableModules.keySet().toArray(new DeploymentModuleIdentifier[availableModules.size()]));
            }
            catch (IOException e) {
                logger.warn((Object)("Could not send initial module availability report to channel " + this.channel), (Throwable)e);
            }
        }
    }

    @Override
    public void deploymentAvailable(DeploymentModuleIdentifier deploymentModuleIdentifier, ModuleDeployment moduleDeployment) {
        try {
            this.sendModuleAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            logger.warn((Object)("Could not send module availability notification of module " + deploymentModuleIdentifier + " to channel " + this.channel), (Throwable)e);
        }
    }

    @Override
    public void deploymentRemoved(DeploymentModuleIdentifier deploymentModuleIdentifier) {
        try {
            this.sendModuleUnAvailability(new DeploymentModuleIdentifier[]{deploymentModuleIdentifier});
        }
        catch (IOException e) {
            logger.debug((Object)("Could not send module un-availability notification of module " + deploymentModuleIdentifier + " to channel " + this.channel), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channel.writeMessage());
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter(this.marshallingStrategy);
        try {
            moduleAvailabilityWriter.writeModuleAvailability(outputStream, availableModules);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendModuleUnAvailability(DeploymentModuleIdentifier[] availableModules) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)this.channel.writeMessage());
        ModuleAvailabilityWriter moduleAvailabilityWriter = new ModuleAvailabilityWriter(this.marshallingStrategy);
        try {
            moduleAvailabilityWriter.writeModuleUnAvailability(outputStream, availableModules);
        }
        finally {
            outputStream.close();
        }
    }

    private class ChannelCloseHandler
    implements CloseHandler<Channel> {
        private ChannelCloseHandler() {
        }

        public void handleClose(Channel closedChannel, IOException exception) {
            logger.debug((Object)("Channel " + closedChannel + " closed. removing deployment listener " + this));
            VersionOneProtocolChannelReceiver.this.deploymentRepository.removeListener(VersionOneProtocolChannelReceiver.this);
        }
    }
}

