/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.pool.Pool;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.subsystem.deployment.AbstractEJBComponentResourceDefinition;
import org.jboss.as.ejb3.subsystem.deployment.EJBComponentType;
import org.jboss.as.ejb3.subsystem.deployment.TimerAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractEJBComponentRuntimeHandler<T extends EJBComponent>
extends AbstractRuntimeOnlyHandler {
    private final Map<PathAddress, ServiceName> componentConfigs = Collections.synchronizedMap(new HashMap());
    private final Class<T> componentClass;
    private final EJBComponentType componentType;

    protected AbstractEJBComponentRuntimeHandler(EJBComponentType componentType, Class<T> componentClass) {
        this.componentType = componentType;
        this.componentClass = componentClass;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String opName = operation.require("operation").asString();
        boolean forWrite = this.isForWrite(opName);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ServiceName serviceName = this.getComponentConfiguration(address);
        T component = this.getComponent(serviceName, address, context, forWrite);
        if ("read-attribute".equals(opName)) {
            String attributeName = operation.require("name").asString();
            this.executeReadAttribute(attributeName, context, component, address);
            context.completeStep();
        } else if ("write-attribute".equals(opName)) {
            String attributeName = operation.require("name").asString();
            this.executeWriteAttribute(attributeName, context, operation, component, address);
        } else {
            this.executeAgainstComponent(context, operation, component, opName, address);
        }
    }

    public void registerComponent(PathAddress address, ServiceName serviceName) {
        this.componentConfigs.put(address, serviceName);
    }

    public void unregisterComponent(PathAddress address) {
        this.componentConfigs.remove(address);
    }

    protected void executeReadAttribute(String attributeName, OperationContext context, T component, PathAddress address) {
        boolean hasPool = this.componentType.hasPool();
        if (AbstractEJBComponentResourceDefinition.COMPONENT_CLASS_NAME.getName().equals(attributeName)) {
            context.getResult().set(component.getComponentName());
        } else if (AbstractEJBComponentResourceDefinition.SECURITY_DOMAIN.getName().equals(attributeName)) {
            ModelNode result = context.getResult();
            EJBSecurityMetaData md = ((EJBComponent)((Object)component)).getSecurityMetaData();
            if (md != null && md.getSecurityDomain() != null) {
                result.set(md.getSecurityDomain());
            }
        } else if (AbstractEJBComponentResourceDefinition.RUN_AS_ROLE.getName().equals(attributeName)) {
            ModelNode result = context.getResult();
            EJBSecurityMetaData md = ((EJBComponent)((Object)component)).getSecurityMetaData();
            if (md != null && md.getRunAs() != null) {
                result.set(md.getRunAs());
            }
        } else if (AbstractEJBComponentResourceDefinition.DECLARED_ROLES.getName().equals(attributeName)) {
            ModelNode result = context.getResult();
            EJBSecurityMetaData md = ((EJBComponent)((Object)component)).getSecurityMetaData();
            if (md != null) {
                result.setEmptyList();
                Set<String> roles = md.getDeclaredRoles();
                if (roles != null) {
                    for (String role : roles) {
                        result.add(role);
                    }
                }
            }
        } else if (this.componentType.hasTimer() && TimerAttributeDefinition.INSTANCE.getName().equals(attributeName)) {
            TimerAttributeDefinition.addTimers(component, context.getResult());
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_AVAILABLE_COUNT.getName().equals(attributeName)) {
            int count = this.componentType.getPool((EJBComponent)((Object)component)).getAvailableCount();
            context.getResult().set(count);
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_CREATE_COUNT.getName().equals(attributeName)) {
            int count = this.componentType.getPool((EJBComponent)((Object)component)).getCreateCount();
            context.getResult().set(count);
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_REMOVE_COUNT.getName().equals(attributeName)) {
            int count = this.componentType.getPool((EJBComponent)((Object)component)).getRemoveCount();
            context.getResult().set(count);
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_CURRENT_SIZE.getName().equals(attributeName)) {
            int size = this.componentType.getPool((EJBComponent)((Object)component)).getCurrentSize();
            context.getResult().set(size);
        } else if (hasPool && AbstractEJBComponentResourceDefinition.POOL_MAX_SIZE.getName().equals(attributeName)) {
            int size = this.componentType.getPool((EJBComponent)((Object)component)).getMaxSize();
            context.getResult().set(size);
        } else {
            throw new IllegalStateException(String.format("Unknown attribute %s", attributeName));
        }
    }

    protected void executeWriteAttribute(String attributeName, OperationContext context, ModelNode operation, T component, PathAddress address) throws OperationFailedException {
        if (this.componentType.hasPool() && AbstractEJBComponentResourceDefinition.POOL_MAX_SIZE.getName().equals(attributeName)) {
            int newSize = AbstractEJBComponentResourceDefinition.POOL_MAX_SIZE.resolveModelAttribute(context, operation).asInt();
            Pool pool = this.componentType.getPool((EJBComponent)((Object)component));
            int oldSize = pool.getMaxSize();
            this.componentType.getPool((EJBComponent)((Object)component)).setMaxSize(newSize);
            if (context.completeStep() != OperationContext.ResultAction.KEEP) {
                pool.setMaxSize(oldSize);
            }
        } else {
            throw EjbMessages.MESSAGES.unknownAttribute(attributeName);
        }
    }

    protected void executeAgainstComponent(OperationContext context, ModelNode operation, T component, String opName, PathAddress address) throws OperationFailedException {
        throw AbstractEJBComponentRuntimeHandler.unknownOperation(opName);
    }

    protected boolean isOperationReadOnly(String opName) {
        throw AbstractEJBComponentRuntimeHandler.unknownOperation(opName);
    }

    private static IllegalStateException unknownOperation(String opName) {
        throw EjbMessages.MESSAGES.unknownOperations(opName);
    }

    private boolean isForWrite(String opName) {
        if ("write-attribute".equals(opName)) {
            return true;
        }
        if ("read-attribute".equals(opName)) {
            return false;
        }
        return !this.isOperationReadOnly(opName);
    }

    private ServiceName getComponentConfiguration(PathAddress operationAddress) throws OperationFailedException {
        PathAddress pa;
        ServiceName config;
        ArrayList<PathElement> relativeAddress = new ArrayList<PathElement>();
        for (int i = operationAddress.size() - 1; i >= 0; --i) {
            PathElement pe = operationAddress.getElement(i);
            relativeAddress.add(0, pe);
            if ("deployment".equals(pe.getKey())) break;
        }
        if ((config = this.componentConfigs.get(pa = PathAddress.pathAddress(relativeAddress))) == null) {
            String exceptionMessage = EjbMessages.MESSAGES.noComponentRegisteredForAddress(operationAddress);
            throw new OperationFailedException(new ModelNode().set(exceptionMessage));
        }
        return config;
    }

    private T getComponent(ServiceName serviceName, PathAddress operationAddress, OperationContext context, boolean forWrite) throws OperationFailedException {
        ServiceRegistry registry = context.getServiceRegistry(forWrite);
        ServiceController controller = registry.getService(serviceName);
        if (controller == null) {
            String exceptionMessage = EjbMessages.MESSAGES.noComponentAvailableForAddress(operationAddress);
            throw new OperationFailedException(new ModelNode().set(exceptionMessage));
        }
        ServiceController.State controllerState = controller.getState();
        if (controllerState != ServiceController.State.UP) {
            String exceptionMessage = EjbMessages.MESSAGES.invalidComponentState(operationAddress, controllerState, ServiceController.State.UP);
            throw new OperationFailedException(new ModelNode().set(exceptionMessage));
        }
        return (T)((Object)((EJBComponent)((Object)this.componentClass.cast(controller.getValue()))));
    }
}

