/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.task;

import java.util.Date;
import javax.ejb.Timer;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;

public class TimerTask<T extends TimerImpl>
implements Runnable {
    protected T timer;
    protected TimerServiceImpl timerService;

    public TimerTask(T timer) {
        if (timer == null) {
            throw EjbMessages.MESSAGES.timerIsNull();
        }
        this.timer = timer;
        this.timerService = ((TimerImpl)timer).getTimerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Date now = new Date();
        EjbLogger.ROOT_LOGGER.debug("Timer task invoked at: " + now + " for timer " + this.timer);
        if (((TimerImpl)this.timer).isInRetry()) {
            EjbLogger.ROOT_LOGGER.debug("Timer in retry mode, skipping this scheduled execution at: " + now);
            return;
        }
        if (!((TimerImpl)this.timer).isActive()) {
            EjbLogger.ROOT_LOGGER.debug("Timer is not active, skipping this scheduled execution at: " + now);
        }
        ((TimerImpl)this.timer).setPreviousRun(new Date());
        Date nextTimeout = this.calculateNextTimeout();
        ((TimerImpl)this.timer).setNextTimeout(nextTimeout);
        ((TimerImpl)this.timer).setTimerState(TimerState.IN_TIMEOUT);
        this.timerService.persistTimer((TimerImpl)this.timer);
        try {
            this.callTimeout();
        }
        catch (Exception e) {
            EjbLogger.ROOT_LOGGER.errorInvokeTimeout((Timer)this.timer, e);
            try {
                EjbLogger.ROOT_LOGGER.timerRetried((Timer)this.timer);
                this.retryTimeout();
            }
            catch (Exception retryException) {
                EjbLogger.ROOT_LOGGER.errorDuringRetryTimeout((Timer)this.timer, e);
            }
        }
        finally {
            this.postTimeoutProcessing();
            this.timerService.persistTimer((TimerImpl)this.timer);
        }
    }

    protected void callTimeout() throws Exception {
        this.timerService.getInvoker().callTimeout((Timer)this.timer);
    }

    protected Date calculateNextTimeout() {
        long intervalDuration = ((TimerImpl)this.timer).getInterval();
        if (intervalDuration > 0L) {
            Date nextExpiration = ((TimerImpl)this.timer).getNextExpiration();
            nextExpiration = new Date(nextExpiration.getTime() + intervalDuration);
            return nextExpiration;
        }
        return null;
    }

    protected T getTimer() {
        return this.timer;
    }

    protected void retryTimeout() throws Exception {
        if (((TimerImpl)this.timer).isActive()) {
            EjbLogger.ROOT_LOGGER.retryingTimeout((Timer)this.timer);
            ((TimerImpl)this.timer).setTimerState(TimerState.RETRY_TIMEOUT);
            this.timerService.persistTimer((TimerImpl)this.timer);
            this.callTimeout();
        } else {
            EjbLogger.ROOT_LOGGER.timerNotActive((Timer)this.timer);
        }
    }

    protected void postTimeoutProcessing() {
        TimerState timerState = ((TimerImpl)this.timer).getState();
        if (timerState == TimerState.IN_TIMEOUT || timerState == TimerState.RETRY_TIMEOUT) {
            if (((TimerImpl)this.timer).getInterval() == 0L) {
                ((TimerImpl)this.timer).expireTimer();
            } else {
                ((TimerImpl)this.timer).setTimerState(TimerState.ACTIVE);
                this.timerService.persistTimer((TimerImpl)this.timer);
            }
        }
    }
}

