/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.jca.core.spi.transaction.TxUtils;

public class TransactionAwareObjectFactory<T>
implements StatefulObjectFactory<T> {
    private final StatefulObjectFactory<T> factory;
    private final TransactionManager tm;

    public TransactionAwareObjectFactory(StatefulObjectFactory<T> factory, TransactionManager tm) {
        this.factory = factory;
        this.tm = tm;
    }

    @Override
    public T createInstance() {
        return this.factory.createInstance();
    }

    @Override
    public void destroyInstance(T instance) {
        Transaction tx = this.getCurrentTransaction();
        if (tx != null && TxUtils.isActive((Transaction)tx)) {
            try {
                tx.registerSynchronization(new DestroySynchronization<T>(this.factory, instance));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.factory.destroyInstance(instance);
        }
    }

    private Transaction getCurrentTransaction() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private static class DestroySynchronization<T>
    implements Synchronization {
        private final StatefulObjectFactory<T> factory;
        private final T instance;

        DestroySynchronization(StatefulObjectFactory<T> factory, T instance) {
            this.factory = factory;
            this.instance = instance;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int arg0) {
            this.factory.destroyInstance(this.instance);
        }
    }
}

