/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.entitycache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.NoSuchEJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;
import org.jboss.logging.Logger;

public class TransactionLocalEntityCache
implements ReadyEntityCache {
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final ConcurrentMap<Object, Map<Object, CacheEntry>> cache = new ConcurrentHashMap<Object, Map<Object, CacheEntry>>(Runtime.getRuntime().availableProcessors());
    private final EntityBeanComponent component;
    private static final Logger logger = Logger.getLogger(TransactionLocalEntityCache.class);

    public TransactionLocalEntityCache(EntityBeanComponent component) {
        this.component = component;
        this.transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
    }

    @Override
    public EntityBeanComponentInstance get(Object key) throws NoSuchEJBException {
        if (!this.isTransactionActive()) {
            return this.createInstance(key);
        }
        Map<Object, CacheEntry> cache = this.prepareCache();
        if (!cache.containsKey(key)) {
            EntityBeanComponentInstance instance = this.createInstance(key);
            this.create(instance);
        }
        return cache.get(key).instance;
    }

    @Override
    public void discard(EntityBeanComponentInstance instance) {
        Object key;
        Map map;
        if (this.isTransactionActive() && (map = (Map)this.cache.get(key = this.transactionSynchronizationRegistry.getTransactionKey())) != null) {
            map.remove(instance.getPrimaryKey());
        }
    }

    @Override
    public void create(EntityBeanComponentInstance instance) throws NoSuchEJBException {
        if (this.isTransactionActive()) {
            Map<Object, CacheEntry> map = this.prepareCache();
            map.put(instance.getPrimaryKey(), new CacheEntry(instance));
        }
    }

    @Override
    public void release(EntityBeanComponentInstance instance, boolean success) {
        if (instance.isDiscarded()) {
            return;
        }
        if (instance.getPrimaryKey() == null) {
            return;
        }
        Object key = this.transactionSynchronizationRegistry.getTransactionKey();
        if (key == null) {
            return;
        }
        Map map = (Map)this.cache.get(key);
        if (map != null) {
            CacheEntry cacheEntry = (CacheEntry)map.get(instance.getPrimaryKey());
            if (cacheEntry == null) {
                throw new IllegalArgumentException("Instance [" + (Object)((Object)instance) + "] not found in cache");
            }
            if (cacheEntry.referenceCount.decrementAndGet() <= 0) {
                if (!success && instance.isRemoved()) {
                    instance.setRemoved(false);
                }
                instance.passivate();
                this.component.getPool().release(instance);
                map.remove(instance.getPrimaryKey());
            } else if (instance.isRemoved() && success) {
                this.component.getPool().release(instance);
                map.remove(instance.getPrimaryKey());
            }
        }
    }

    @Override
    public void reference(EntityBeanComponentInstance instance) {
        Map<Object, CacheEntry> cache = this.prepareCache();
        CacheEntry cacheEntry = cache.get(instance.getPrimaryKey());
        if (cacheEntry == null) {
            throw new IllegalArgumentException("Instance [" + (Object)((Object)instance) + "] not found in cache");
        }
        cacheEntry.referenceCount.incrementAndGet();
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
    }

    private Map<Object, CacheEntry> prepareCache() {
        final Object key = this.transactionSynchronizationRegistry.getTransactionKey();
        Map<Object, CacheEntry> map = (Map<Object, CacheEntry>)this.cache.get(key);
        if (map != null) {
            return map;
        }
        map = Collections.synchronizedMap(new HashMap());
        Map existing = this.cache.putIfAbsent(key, map);
        if (existing != null) {
            map = existing;
        }
        this.transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                TransactionLocalEntityCache.this.cache.remove(key);
            }
        });
        return map;
    }

    private EntityBeanComponentInstance createInstance(Object pk) {
        EntityBeanComponentInstance instance = this.component.getPool().get();
        instance.associate(pk);
        return instance;
    }

    private boolean isTransactionActive() {
        return this.transactionSynchronizationRegistry.getTransactionKey() != null;
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final EntityBeanComponentInstance instance;

        private CacheEntry(EntityBeanComponentInstance instance) {
            this.instance = instance;
        }
    }
}

