/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.xnio.IoFuture;

public class DescriptorBasedEJBClientContextService
implements Service<EJBClientContext> {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "dd-based-ejb-client-context"});
    private static final Logger logger = Logger.getLogger(DescriptorBasedEJBClientContextService.class);
    private static final long DEFAULT_CONNECTION_TIMEOUT = 5000L;
    private final List<InjectedValue<AbstractOutboundConnectionService>> remotingOutboundConnections = new ArrayList<InjectedValue<AbstractOutboundConnectionService>>();
    private final InjectedValue<LocalEjbReceiver> localEjbReceiverInjectedValue = new InjectedValue();
    private volatile EJBClientContext ejbClientContext;

    public synchronized void start(StartContext startContext) throws StartException {
        EJBClientContext context = EJBClientContext.create();
        LocalEjbReceiver localEjbReceiver = (LocalEjbReceiver)((Object)this.localEjbReceiverInjectedValue.getOptionalValue());
        if (localEjbReceiver != null) {
            context.registerEJBReceiver((EJBReceiver)localEjbReceiver);
            logger.debug((Object)("Added a local EJB receiver to descriptor based EJB client context named " + startContext.getController().getName()));
        }
        Collection<Connection> connections = this.createRemotingConnections();
        for (Connection conection : connections) {
            context.registerConnection(conection);
        }
        logger.debug((Object)("Added " + connections.size() + " remoting EJB receivers to descriptor based EJB client context named " + startContext.getController().getName()));
        this.ejbClientContext = context;
    }

    public synchronized void stop(StopContext context) {
        this.ejbClientContext = null;
    }

    public EJBClientContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.ejbClientContext;
    }

    public void addRemotingConnectionDependency(ServiceBuilder<EJBClientContext> serviceBuilder, ServiceName serviceName) {
        InjectedValue value = new InjectedValue();
        serviceBuilder.addDependency(serviceName, AbstractOutboundConnectionService.class, (Injector)value);
        this.remotingOutboundConnections.add((InjectedValue<AbstractOutboundConnectionService>)value);
    }

    public Injector<LocalEjbReceiver> getLocalEjbReceiverInjector() {
        return this.localEjbReceiverInjectedValue;
    }

    private Collection<Connection> createRemotingConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (InjectedValue<AbstractOutboundConnectionService> injectedValue : this.remotingOutboundConnections) {
            AbstractOutboundConnectionService outboundConnectionService = (AbstractOutboundConnectionService)injectedValue.getValue();
            String connectionName = outboundConnectionService.getConnectionName();
            logger.debug((Object)("Creating remoting EJB receiver for connection " + connectionName));
            try {
                IoFuture futureConnection = outboundConnectionService.connect();
                Connection connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
                connections.add(connection);
            }
            catch (IOException ioe) {
                logger.warn((Object)(connectionName + " connection will not be used for EJB client context due " + "to error during connection creation"), (Throwable)ioe);
            }
        }
        return connections;
    }
}

