/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.subsystem.CacheFactoryResourceDefinition;
import org.jboss.as.ejb3.subsystem.ClusterPassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3AsyncServiceAdd;
import org.jboss.as.ejb3.subsystem.EJB3IIOPAdd;
import org.jboss.as.ejb3.subsystem.EJB3RemoteServiceAdd;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.EJB3ThreadPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.FilePassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EJB3Subsystem12Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final EJB3Subsystem12Parser INSTANCE = new EJB3Subsystem12Parser();

    private EJB3Subsystem12Parser() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:ejb3:1.2", false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("default-slsb-instance-pool") || model.hasDefined("default-stateful-bean-access-timeout") || model.hasDefined("default-singleton-bean-access-timeout")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.SESSION_BEAN.getLocalName());
        }
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-stateful-bean-access-timeout") || model.hasDefined("default-sfsb-cache") || model.hasDefined("default-clustered-sfsb-cache")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATEFUL.getLocalName());
            this.writeStatefulBean(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-singleton-bean-access-timeout")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.SINGLETON.getLocalName());
            this.writeSingletonBean(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-slsb-instance-pool") || model.hasDefined("default-stateful-bean-access-timeout") || model.hasDefined("default-singleton-bean-access-timeout")) {
            writer.writeEndElement();
        }
        if (model.hasDefined("default-mdb-instance-pool") || model.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.MDB.getLocalName());
            this.writeMDB(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("strict-max-bean-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.POOLS.getLocalName());
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, model);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (model.hasDefined("cache")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.CACHES.getLocalName());
            this.writeCaches(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("cluster-passivation-store") || model.hasDefined("file-passivation-store")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.PASSIVATION_STORES.getLocalName());
            this.writeFilePassivationStores(writer, model);
            this.writeClusterPassivationStores(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("async")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.ASYNC.getLocalName());
            this.writeAsync(writer, model.get(new String[]{"service", "async"}));
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("timer-service")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.TIMER_SERVICE.getLocalName());
            ModelNode timerServiceModel = model.get(new String[]{"service", "timer-service"});
            this.writeTimerService(writer, timerServiceModel);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("remote")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.REMOTE.getLocalName());
            this.writeRemote(writer, model.get(new String[]{"service", "remote"}));
            writer.writeEndElement();
        }
        if (model.hasDefined("thread-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.THREAD_POOLS.getLocalName());
            ModelNode iiopModel = model.get("thread-pool");
            this.writeThreadPools(writer, iiopModel);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("iiop")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.IIOP.getLocalName());
            this.writeIIOP(writer, model.get(new String[]{"service", "iiop"}));
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeIIOP(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeAttribute(EJB3SubsystemXMLAttribute.USE_QUALIFIED_NAME.getLocalName(), model.require("use-qualified-name").asString());
        writer.writeAttribute(EJB3SubsystemXMLAttribute.ENABLE_BY_DEFAULT.getLocalName(), model.require("enable-by-default").asString());
    }

    private void writeThreadPools(XMLExtendedStreamWriter writer, ModelNode threadPoolsModel) throws XMLStreamException {
        for (Property threadPool : threadPoolsModel.asPropertyList()) {
            writer.writeStartElement(EJB3SubsystemXMLElement.THREAD_POOL.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), threadPool.getName());
            if (threadPool.getValue().has("max-threads")) {
                writer.writeAttribute(EJB3SubsystemXMLAttribute.MAX_THREADS.getLocalName(), threadPool.getValue().get("max-threads").asString());
            }
            if (threadPool.getValue().has("keepalive-time")) {
                writer.writeAttribute(EJB3SubsystemXMLAttribute.KEEPALIVE_TIME.getLocalName(), threadPool.getValue().get("keepalive-time").asString());
            }
            writer.writeEndElement();
        }
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode ejb3SubsystemAddOperation = new ModelNode();
        ejb3SubsystemAddOperation.get("operation").set("add");
        ejb3SubsystemAddOperation.get("address").add("subsystem", "ejb3");
        operations.add(ejb3SubsystemAddOperation);
        EnumSet<EJB3SubsystemXMLElement> encountered = EnumSet.noneOf(EJB3SubsystemXMLElement.class);
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemNamespace.forUri(reader.getNamespaceURI())) {
                case EJB3_1_2: {
                    EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
                    if (!encountered.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    switch (element) {
                        case CACHES: {
                            this.parseCaches(reader, operations);
                            continue block15;
                        }
                        case PASSIVATION_STORES: {
                            this.parsePassivationStores(reader, operations);
                            continue block15;
                        }
                        case MDB: {
                            this.parseMDB(reader, operations, ejb3SubsystemAddOperation);
                            continue block15;
                        }
                        case POOLS: {
                            this.parsePools(reader, operations);
                            continue block15;
                        }
                        case REMOTE: {
                            this.parseRemote(reader, operations);
                            continue block15;
                        }
                        case ASYNC: {
                            this.parseAsync(reader, operations);
                            continue block15;
                        }
                        case SESSION_BEAN: {
                            this.parseSessionBean(reader, operations, ejb3SubsystemAddOperation);
                            continue block15;
                        }
                        case TIMER_SERVICE: {
                            this.parseTimerService(reader, operations);
                            continue block15;
                        }
                        case THREAD_POOLS: {
                            this.parseThreadPools(reader, operations);
                            continue block15;
                        }
                        case IIOP: {
                            this.parseIIOP(reader, operations);
                            continue block15;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static String parseDefaultTimeout(XMLExtendedStreamReader reader, String element) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        String value = reader.getElementText();
        if (value == null || value.trim().isEmpty()) {
            EjbMessages.MESSAGES.invalidValueForElement(value, element, reader.getLocation());
            throw new XMLStreamException("Invalid value: " + value + " for '" + element + "' element", reader.getLocation());
        }
        return value.trim();
    }

    private void writeRemote(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeAttribute(EJB3SubsystemXMLAttribute.CONNECTOR_REF.getLocalName(), model.require("connector-ref").asString());
        writer.writeAttribute(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME.getLocalName(), model.require("thread-pool-name").asString());
    }

    private void writeAsync(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeAttribute(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME.getLocalName(), model.require("thread-pool-name").asString());
    }

    private void writeMDB(XMLExtendedStreamWriter writer, ModelNode mdbModelNode) throws XMLStreamException {
        if (mdbModelNode.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.RESOURCE_ADAPTER_REF.getLocalName());
            String resourceAdapterName = mdbModelNode.get("default-resource-adapter-name").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName(), resourceAdapterName);
            writer.writeEndElement();
        }
        if (mdbModelNode.hasDefined("default-mdb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = mdbModelNode.get("default-mdb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writeSessionBean(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            ModelNode statelessBeanModeNode = model.get(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, statelessBeanModeNode);
            writer.writeEndElement();
        }
    }

    private void writeSingletonBean(XMLExtendedStreamWriter writer, ModelNode singletonBeanModel) throws XMLStreamException {
        String defaultAccessTimeout = singletonBeanModel.get("default-singleton-bean-access-timeout").asString();
        writer.writeAttribute(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT.getLocalName(), defaultAccessTimeout);
    }

    private void writeStatefulBean(XMLExtendedStreamWriter writer, ModelNode statefulBeanModel) throws XMLStreamException {
        String cache;
        if (statefulBeanModel.hasDefined("default-stateful-bean-access-timeout")) {
            String defaultAccessTimeout = statefulBeanModel.get("default-stateful-bean-access-timeout").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT.getLocalName(), defaultAccessTimeout);
        }
        if (statefulBeanModel.hasDefined("default-sfsb-cache")) {
            cache = statefulBeanModel.get("default-sfsb-cache").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.CACHE_REF.getLocalName(), cache);
        }
        if (statefulBeanModel.hasDefined("default-clustered-sfsb-cache")) {
            cache = statefulBeanModel.get("default-clustered-sfsb-cache").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.CLUSTERED_CACHE_REF.getLocalName(), cache);
        }
    }

    private void writeDefaultSLSBPool(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = model.get("default-slsb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writePools(XMLExtendedStreamWriter writer, ModelNode poolsModelNode) throws XMLStreamException {
        if (poolsModelNode.hasDefined(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName())) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            ModelNode beanInstancePoolsModelNode = poolsModelNode.get(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, beanInstancePoolsModelNode);
            writer.writeEndElement();
        }
    }

    private void writeBeanInstancePools(XMLExtendedStreamWriter writer, ModelNode beanInstancePoolModelNode) throws XMLStreamException {
        if (beanInstancePoolModelNode.hasDefined("strict-max-bean-instance-pool")) {
            List strictMaxPools = beanInstancePoolModelNode.get("strict-max-bean-instance-pool").asPropertyList();
            for (Property property : strictMaxPools) {
                writer.writeStartElement(EJB3SubsystemXMLElement.STRICT_MAX_POOL.getLocalName());
                ModelNode strictMaxPoolModelNode = property.getValue();
                this.writeStrictMaxPoolConfig(writer, strictMaxPoolModelNode);
                writer.writeEndElement();
            }
        }
    }

    private void writeStrictMaxPoolConfig(XMLExtendedStreamWriter writer, ModelNode strictMaxPoolModelNode) throws XMLStreamException {
        String poolName = strictMaxPoolModelNode.get("name").asString();
        writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), poolName);
        StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
    }

    private void writeCaches(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        List caches = model.get("cache").asPropertyList();
        for (Property property : caches) {
            writer.writeStartElement(EJB3SubsystemXMLElement.CACHE.getLocalName());
            ModelNode cache = property.getValue();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), cache.get("name").asString());
            CacheFactoryResourceDefinition.PASSIVATION_STORE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            CacheFactoryResourceDefinition.ALIASES.marshallAsElement(cache, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private void writeClusterPassivationStores(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("cluster-passivation-store")) {
            List caches = model.get("cluster-passivation-store").asPropertyList();
            for (Property property : caches) {
                writer.writeStartElement(EJB3SubsystemXMLElement.CLUSTER_PASSIVATION_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), store.get("name").asString());
                PassivationStoreResourceDefinition.IDLE_TIMEOUT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.MAX_SIZE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.BACKING_CACHE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.PASSIVATE_EVENTS_ON_REPLICATE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeFilePassivationStores(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("file-passivation-store")) {
            List caches = model.get("file-passivation-store").asPropertyList();
            for (Property property : caches) {
                writer.writeStartElement(EJB3SubsystemXMLElement.FILE_PASSIVATION_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), store.get("name").asString());
                PassivationStoreResourceDefinition.IDLE_TIMEOUT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.MAX_SIZE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.RELATIVE_TO.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.GROUPS_PATH.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.SESSIONS_PATH.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.SUBDIRECTORY_COUNT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeTimerService(XMLExtendedStreamWriter writer, ModelNode timerServiceModel) throws XMLStreamException {
        TimerServiceResourceDefinition.THREAD_POOL_NAME.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
        if (TimerServiceResourceDefinition.PATH.isMarshallable(timerServiceModel) || TimerServiceResourceDefinition.RELATIVE_TO.isMarshallable(timerServiceModel)) {
            writer.writeEmptyElement(EJB3SubsystemXMLElement.DATA_STORE.getLocalName());
            TimerServiceResourceDefinition.PATH.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
            TimerServiceResourceDefinition.RELATIVE_TO.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
        }
    }

    private void parseRemote(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String connectorName = null;
        String threadPoolName = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.CONNECTOR_REF, EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CONNECTOR_REF: {
                    connectorName = value;
                    continue block4;
                }
                case THREAD_POOL_NAME: {
                    threadPoolName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(EJB3RemoteServiceAdd.create(connectorName, threadPoolName));
    }

    private void parseAsync(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String threadPoolName = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case THREAD_POOL_NAME: {
                    threadPoolName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(EJB3AsyncServiceAdd.create(threadPoolName));
    }

    private void parseIIOP(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        boolean enableByDefault = true;
        boolean useQualifiedName = true;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.ENABLE_BY_DEFAULT, EJB3SubsystemXMLAttribute.USE_QUALIFIED_NAME);
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case ENABLE_BY_DEFAULT: {
                    enableByDefault = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block4;
                }
                case USE_QUALIFIED_NAME: {
                    useQualifiedName = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(EJB3IIOPAdd.create(enableByDefault, useQualifiedName));
    }

    private ModelNode parseMDB(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ModelNode defaultRAName;
        ModelNode mdbModelNode = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case RESOURCE_ADAPTER_REF: {
                    String resourceAdapterName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.parseAndSetParameter(resourceAdapterName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!ejb3SubsystemAddOperation.hasDefined("default-resource-adapter-name") && (defaultRAName = EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME.getDefaultValue()) != null) {
            ejb3SubsystemAddOperation.get("default-resource-adapter-name").set(defaultRAName);
        }
        return mdbModelNode;
    }

    private void parseSessionBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATELESS: {
                    this.parseStatelessBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block5;
                }
                case STATEFUL: {
                    this.parseStatefulBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block5;
                }
                case SINGLETON: {
                    this.parseSingletonBean(reader, operations, ejb3SubsystemAddOperation);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStatelessBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOL_REF: {
                    String poolName = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName());
                    EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL.parseAndSetParameter(poolName, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStatefulBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT, EJB3SubsystemXMLAttribute.CACHE_REF);
        String defaultAccessTimeout = null;
        String cache = null;
        String clusteredCache = null;
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_ACCESS_TIMEOUT: {
                    defaultAccessTimeout = EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_ACCESS_TIMEOUT.parse(value, (XMLStreamReader)reader).asString();
                    break;
                }
                case CACHE_REF: {
                    cache = EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_CACHE.parse(value, (XMLStreamReader)reader).asString();
                    break;
                }
                case CLUSTERED_CACHE_REF: {
                    clusteredCache = EJB3SubsystemRootResourceDefinition.DEFAULT_CLUSTERED_SFSB_CACHE.parse(value, (XMLStreamReader)reader).asString();
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
            missingRequiredAttributes.remove((Object)attribute);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
        EJB3SubsystemRootResourceDefinition.DEFAULT_STATEFUL_BEAN_ACCESS_TIMEOUT.parseAndSetParameter(defaultAccessTimeout, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
        EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_CACHE.parseAndSetParameter(cache, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
        EJB3SubsystemRootResourceDefinition.DEFAULT_CLUSTERED_SFSB_CACHE.parseAndSetParameter(clusteredCache, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
    }

    private void parseSingletonBean(XMLExtendedStreamReader reader, List<ModelNode> operations, ModelNode ejb3SubsystemAddOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        EnumSet<EJB3SubsystemXMLAttribute> missingRequiredAttributes = EnumSet.of(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT);
        String defaultAccessTimeout = null;
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_ACCESS_TIMEOUT: {
                    defaultAccessTimeout = EJB3SubsystemRootResourceDefinition.DEFAULT_SINGLETON_BEAN_ACCESS_TIMEOUT.parse(value, (XMLStreamReader)reader).asString();
                    missingRequiredAttributes.remove((Object)EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!missingRequiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missingRequiredAttributes);
        }
        EJB3SubsystemRootResourceDefinition.DEFAULT_SINGLETON_BEAN_ACCESS_TIMEOUT.parseAndSetParameter(defaultAccessTimeout, ejb3SubsystemAddOperation, (XMLStreamReader)reader);
    }

    private void parsePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case BEAN_INSTANCE_POOLS: {
                    this.parseBeanInstancePools(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBeanInstancePools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STRICT_MAX_POOL: {
                    this.parseStrictMaxPool(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStrictMaxPool(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String poolName = null;
        Integer maxPoolSize = null;
        Long timeout = null;
        String unit = null;
        block6: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    poolName = value;
                    continue block6;
                }
                case MAX_POOL_SIZE: {
                    maxPoolSize = StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.parse(value, (XMLStreamReader)reader).asInt();
                    continue block6;
                }
                case INSTANCE_AQUISITION_TIMEOUT: {
                    timeout = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.parse(value, (XMLStreamReader)reader).asLong();
                    continue block6;
                }
                case INSTANCE_AQUISITION_TIMEOUT_UNIT: {
                    unit = StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.parse(value, (XMLStreamReader)reader).asString();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (poolName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddStrictMaxBeanInstancePoolOperation(poolName, maxPoolSize, timeout, unit));
    }

    private void parseCaches(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case CACHE: {
                    this.parseCache(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCache(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        String passivationStore = null;
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case NAME: {
                    name = value;
                    continue block5;
                }
                case PASSIVATION_STORE_REF: {
                    passivationStore = CacheFactoryResourceDefinition.PASSIVATION_STORE.parse(value, (XMLStreamReader)reader).asString();
                    continue block5;
                }
                case ALIASES: {
                    for (String alias : reader.getListAttributeValue(i)) {
                        aliases.add(CacheFactoryResourceDefinition.ALIASES.parse(alias, (XMLStreamReader)reader).asString());
                    }
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddStatefulCacheOperation(name, aliases, passivationStore));
    }

    private void parsePassivationStores(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case FILE_PASSIVATION_STORE: {
                    this.parseFilePassivationStore(reader, operations);
                    continue block4;
                }
                case CLUSTER_PASSIVATION_STORE: {
                    this.parseClusterPassivationStore(reader, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFilePassivationStore(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        Integer maxSize = null;
        Long timeout = null;
        String unit = null;
        String relativeTo = null;
        String groupsPath = null;
        String sessionsPath = null;
        Integer subdirectoryCount = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case MAX_SIZE: {
                    maxSize = FilePassivationStoreResourceDefinition.MAX_SIZE.parse(value, (XMLStreamReader)reader).asInt();
                    continue block10;
                }
                case IDLE_TIMEOUT: {
                    timeout = PassivationStoreResourceDefinition.IDLE_TIMEOUT.parse(value, (XMLStreamReader)reader).asLong();
                    continue block10;
                }
                case IDLE_TIMEOUT_UNIT: {
                    unit = PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.parse(value, (XMLStreamReader)reader).asString();
                    continue block10;
                }
                case RELATIVE_TO: {
                    relativeTo = FilePassivationStoreResourceDefinition.RELATIVE_TO.parse(value, (XMLStreamReader)reader).asString();
                    continue block10;
                }
                case GROUPS_PATH: {
                    groupsPath = FilePassivationStoreResourceDefinition.GROUPS_PATH.parse(value, (XMLStreamReader)reader).asString();
                    continue block10;
                }
                case SESSIONS_PATH: {
                    sessionsPath = FilePassivationStoreResourceDefinition.SESSIONS_PATH.parse(value, (XMLStreamReader)reader).asString();
                    continue block10;
                }
                case SUBDIRECTORY_COUNT: {
                    subdirectoryCount = FilePassivationStoreResourceDefinition.SUBDIRECTORY_COUNT.parse(value, (XMLStreamReader)reader).asInt();
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddFilePassivationStoreOperation(name, maxSize, timeout, unit, relativeTo, groupsPath, sessionsPath, subdirectoryCount));
    }

    private void parseClusterPassivationStore(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        Integer maxSize = null;
        Long timeout = null;
        String unit = null;
        String backingCache = null;
        Boolean passivateEventsOnReplicate = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            switch (EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i))) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case MAX_SIZE: {
                    maxSize = ClusterPassivationStoreResourceDefinition.MAX_SIZE.parse(value, (XMLStreamReader)reader).asInt();
                    continue block8;
                }
                case IDLE_TIMEOUT: {
                    timeout = PassivationStoreResourceDefinition.IDLE_TIMEOUT.parse(value, (XMLStreamReader)reader).asLong();
                    continue block8;
                }
                case IDLE_TIMEOUT_UNIT: {
                    unit = PassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.parse(value, (XMLStreamReader)reader).asString();
                    continue block8;
                }
                case BACKING_CACHE: {
                    backingCache = ClusterPassivationStoreResourceDefinition.BACKING_CACHE.parse(value, (XMLStreamReader)reader).asString();
                    continue block8;
                }
                case PASSIVATE_EVENTS_ON_REPLICATE: {
                    passivateEventsOnReplicate = ClusterPassivationStoreResourceDefinition.PASSIVATE_EVENTS_ON_REPLICATE.parse(value, (XMLStreamReader)reader).asBoolean();
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        operations.add(this.createAddClusterPassivationStoreOperation(name, maxSize, timeout, unit, backingCache, passivateEventsOnReplicate));
    }

    private void parseTimerService(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "timer-service");
        ModelNode timerServiceAdd = new ModelNode();
        timerServiceAdd.get("operation").set("add");
        timerServiceAdd.get("address").set(address);
        String dataStorePath = null;
        String dataStorePathRelativeTo = null;
        int attCount = reader.getAttributeCount();
        String threadPoolName = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block10: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case THREAD_POOL_NAME: {
                    threadPoolName = value;
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        timerServiceAdd.get("thread-pool-name").set(threadPoolName);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case DATA_STORE: {
                    int count = reader.getAttributeCount();
                    block12: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case PATH: {
                                if (dataStorePath != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePath = TimerServiceResourceDefinition.PATH.parse(value, (XMLStreamReader)reader).asString();
                                continue block12;
                            }
                            case RELATIVE_TO: {
                                if (dataStorePathRelativeTo != null) {
                                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                }
                                dataStorePathRelativeTo = TimerServiceResourceDefinition.RELATIVE_TO.parse(value, (XMLStreamReader)reader).asString();
                                continue block12;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (dataStorePath == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.PATH));
                    }
                    timerServiceAdd.get("path").set(dataStorePath);
                    if (dataStorePathRelativeTo != null) {
                        timerServiceAdd.get("relative-to").set(dataStorePathRelativeTo);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(timerServiceAdd);
    }

    private void parseThreadPools(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case THREAD_POOL: {
                    this.parseThreadPool(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseThreadPool(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int attCount = reader.getAttributeCount();
        String threadPoolName = null;
        Integer maxThreads = null;
        Integer keepAlive = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.NAME);
        block5: for (int i = 0; i < attCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    threadPoolName = value.trim();
                    continue block5;
                }
                case MAX_THREADS: {
                    maxThreads = EJB3ThreadPoolResourceDefinition.MAX_THREADS.parse(value, (XMLStreamReader)reader).asInt();
                    continue block5;
                }
                case KEEPALIVE_TIME: {
                    keepAlive = EJB3ThreadPoolResourceDefinition.KEEPALIVE_TIME.parse(value, (XMLStreamReader)reader).asInt();
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("thread-pool", threadPoolName);
        ModelNode threadPoolAdd = new ModelNode();
        threadPoolAdd.get("operation").set("add");
        threadPoolAdd.get("address").set(address);
        if (maxThreads != null) {
            threadPoolAdd.get("max-threads").set(maxThreads.intValue());
        }
        if (keepAlive != null) {
            threadPoolAdd.get("keepalive-time").set(keepAlive.intValue());
        }
        operations.add(threadPoolAdd);
    }

    private void parseAttributes(XMLExtendedStreamReader reader, ModelNode node, EnumSet<EJB3SubsystemXMLAttribute> expectedAttributes, EnumSet<EJB3SubsystemXMLAttribute> requiredAttributes) throws XMLStreamException {
        EnumSet<EJB3SubsystemXMLAttribute> parsedAttributes = EnumSet.noneOf(EJB3SubsystemXMLAttribute.class);
        if (requiredAttributes == null) {
            requiredAttributes = EnumSet.noneOf(EJB3SubsystemXMLAttribute.class);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            if (!expectedAttributes.contains((Object)attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            if (!parsedAttributes.add(attribute)) {
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
            }
            requiredAttributes.remove((Object)attribute);
            node.get(attribute.getLocalName()).set(attrValue);
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
    }

    private ModelNode createAddStrictMaxBeanInstancePoolOperation(String name, Integer maxPoolSize, Long timeout, String timeoutUnit) {
        ModelNode addStrictMaxPoolOperation = new ModelNode();
        addStrictMaxPoolOperation.get("operation").set("add");
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"strict-max-bean-instance-pool", (String)name)});
        addStrictMaxPoolOperation.get("address").set(address.toModelNode());
        if (maxPoolSize != null) {
            addStrictMaxPoolOperation.get("max-pool-size").set(maxPoolSize.intValue());
        }
        if (timeout != null) {
            addStrictMaxPoolOperation.get("timeout").set(timeout.longValue());
        }
        if (timeoutUnit != null) {
            addStrictMaxPoolOperation.get("timeout-unit").set(timeoutUnit);
        }
        return addStrictMaxPoolOperation;
    }

    private ModelNode createAddStatefulCacheOperation(String name, Set<String> aliases, String passivationStoreRef) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)"cache", (String)name)});
        operation.get("address").set(address.toModelNode());
        if (passivationStoreRef != null) {
            operation.get("passivation-store").set(passivationStoreRef);
        }
        if (!aliases.isEmpty()) {
            ModelNode aliasModel = operation.get("aliases").setEmptyList();
            for (String alias : aliases) {
                aliasModel.add(alias);
            }
        }
        return operation;
    }

    private ModelNode createAddPassivationStoreOperation(String operationName, String name, Integer maxSize, Long idleTimeout, String idleTimeoutUnit) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        PathAddress address = this.getEJB3SubsystemAddress().append(new PathElement[]{PathElement.pathElement((String)operationName, (String)name)});
        operation.get("address").set(address.toModelNode());
        if (idleTimeout != null) {
            operation.get("idle-timeout").set(idleTimeout.longValue());
        }
        if (idleTimeoutUnit != null) {
            operation.get("idle-timeout-unit").set(idleTimeoutUnit);
        }
        if (maxSize != null) {
            operation.get("max-size").set(maxSize.intValue());
        }
        return operation;
    }

    private ModelNode createAddFilePassivationStoreOperation(String name, Integer maxSize, Long idleTimeout, String idleTimeoutUnit, String relativeTo, String groupsPath, String sessionsPath, Integer subdirectoryCount) {
        ModelNode operation = this.createAddPassivationStoreOperation("file-passivation-store", name, maxSize, idleTimeout, idleTimeoutUnit);
        if (relativeTo != null) {
            operation.get("relative-to").set(relativeTo);
        }
        if (groupsPath != null) {
            operation.get("groups-path").set(groupsPath);
        }
        if (sessionsPath != null) {
            operation.get("sessions-path").set(sessionsPath);
        }
        if (subdirectoryCount != null) {
            operation.get("subdirectory-count").set(subdirectoryCount.intValue());
        }
        return operation;
    }

    private ModelNode createAddClusterPassivationStoreOperation(String name, Integer maxSize, Long idleTimeout, String idleTimeoutUnit, String backingCache, Boolean passivateEventsOnReplicate) {
        ModelNode operation = this.createAddPassivationStoreOperation("cluster-passivation-store", name, maxSize, idleTimeout, idleTimeoutUnit);
        if (backingCache != null) {
            operation.get("backing-cache").set(backingCache);
        }
        if (passivateEventsOnReplicate != null) {
            operation.get("passivate-events-on-replicate").set(passivateEventsOnReplicate.booleanValue());
        }
        return operation;
    }

    private PathAddress getEJB3SubsystemAddress() {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"ejb3")});
    }
}

