/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntry;

public class NonPassivatingBackingCacheEntry<K extends Serializable, V extends Cacheable<K>>
extends AbstractBackingCacheEntry<K, V>
implements BackingCacheEntry<K, V> {
    private static final long serialVersionUID = 1325918596862109742L;
    private final V wrapped;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean valid = true;

    public NonPassivatingBackingCacheEntry(V wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public V getUnderlyingItem() {
        return this.wrapped;
    }

    @Override
    public boolean isModified() {
        return this.wrapped.isModified();
    }

    @Override
    public K getId() {
        return (K)((Serializable)this.wrapped.getId());
    }

    @Override
    public void lock() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw EjbMessages.MESSAGES.lockAcquisitionInterrupted(e, this.wrapped.getId());
        }
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

