/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl.backing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.PassivatingBackingCache;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntry;
import org.jboss.logging.Logger;

public class SerializationGroupImpl<K extends Serializable, V extends Cacheable<K>>
extends AbstractBackingCacheEntry<UUID, Cacheable<UUID>>
implements SerializationGroup<K, V, UUID> {
    private static final long serialVersionUID = -6181048392582344057L;
    private static final Logger log = Logger.getLogger(SerializationGroupImpl.class);
    private final UUID id = UUID.randomUUID();
    private Map<K, V> memberObjects = new ConcurrentHashMap();
    private transient Map<K, SerializationGroupMember<K, V, UUID>> active = new HashMap<K, SerializationGroupMember<K, V, UUID>>();
    private transient Set<K> inUseKeys = new HashSet<K>();
    private transient PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache;
    private boolean clustered;
    private transient boolean groupModified;
    private transient ReentrantLock lock = new ReentrantLock();

    @Override
    public UUID getId() {
        return this.id;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    @Override
    public void addMember(SerializationGroupMember<K, V, UUID> member) {
        Serializable key = (Serializable)member.getId();
        if (this.memberObjects.containsKey(key)) {
            throw EjbMessages.MESSAGES.duplicateSerializationGroupMember(key, this.id);
        }
        log.tracef("Adding member %s to serialization group %s", (Object)key, (Object)this);
        this.memberObjects.put(key, member.getUnderlyingItem());
        this.active.put(key, member);
    }

    @Override
    public void removeMember(K key) {
        this.removeActive(key);
        this.memberObjects.remove(key);
    }

    @Override
    public int size() {
        return this.memberObjects.size();
    }

    @Override
    public V getMemberObject(K key) {
        return (V)((Cacheable)this.memberObjects.get(key));
    }

    @Override
    public void prePassivate() {
        Iterator<SerializationGroupMember<K, V, UUID>> members = this.active.values().iterator();
        while (members.hasNext()) {
            SerializationGroupMember<K, V, UUID> member = members.next();
            member.prePassivate();
            members.remove();
        }
    }

    @Override
    public void postActivate() {
    }

    @Override
    public void preReplicate() {
        Iterator<SerializationGroupMember<K, V, UUID>> members = this.active.values().iterator();
        while (members.hasNext()) {
            SerializationGroupMember<K, V, UUID> member = members.next();
            member.preReplicate();
            members.remove();
        }
    }

    @Override
    public void postReplicate() {
    }

    @Override
    public void addActive(SerializationGroupMember<K, V, UUID> member) {
        Serializable key = (Serializable)member.getId();
        this.active.put(key, member);
    }

    @Override
    public void removeActive(K key) {
        this.active.remove(key);
    }

    @Override
    public void addInUse(K key) {
        this.inUseKeys.add(key);
        this.setInUse(true);
    }

    @Override
    public void removeInUse(K key) {
        if (this.inUseKeys.remove(key)) {
            if (this.inUseKeys.size() == 0) {
                this.setInUse(false);
            } else {
                this.setLastUsed(System.currentTimeMillis());
            }
        } else if (!this.memberObjects.containsKey(key)) {
            throw EjbMessages.MESSAGES.missingSerializationGroupMember(key, this);
        }
    }

    @Override
    public int getInUseCount() {
        return this.inUseKeys.size();
    }

    @Override
    public boolean isModified() {
        boolean result = this.groupModified;
        this.setGroupModified(false);
        return result;
    }

    @Override
    public boolean isGroupModified() {
        return this.groupModified;
    }

    @Override
    public void setGroupModified(boolean modified) {
        this.groupModified = modified;
    }

    @Override
    public Cacheable<UUID> getUnderlyingItem() {
        return null;
    }

    @Override
    public PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> getGroupCache() {
        return this.groupCache;
    }

    @Override
    public void lock() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw EjbMessages.MESSAGES.lockAcquisitionInterrupted(e, this);
        }
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public void setGroupCache(PassivatingBackingCache<UUID, Cacheable<UUID>, SerializationGroup<K, V, UUID>> groupCache) {
        this.groupCache = groupCache;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new ReentrantLock();
        this.memberObjects = (Map)in.readObject();
        this.active = new HashMap<K, SerializationGroupMember<K, V, UUID>>();
        this.inUseKeys = new HashSet<K>();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.memberObjects);
    }
}

