/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBLocalObject;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.NamespaceConfigurator;
import org.jboss.as.ee.component.NamespaceViewConfigurator;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.interceptors.ComponentDispatcherInterceptor;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.Ejb2xViewType;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.RemoteHomeViewInstanceFactory;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.interceptors.EjbExceptionTransformingInterceptorFactories;
import org.jboss.as.ejb3.component.interceptors.LoggingInterceptor;
import org.jboss.as.ejb3.deployment.ApplicableMethodInformation;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsViewConfigurator;
import org.jboss.as.ejb3.security.EJBMethodSecurityAttribute;
import org.jboss.as.ejb3.security.EJBSecurityViewConfigurator;
import org.jboss.as.ejb3.security.SecurityContextInterceptorFactory;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.timerservice.NonFunctionalTimerService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public abstract class EJBComponentDescription
extends ComponentDescription {
    private TransactionManagementType transactionManagementType = TransactionManagementType.CONTAINER;
    private EnterpriseBeanMetaData descriptorData;
    private String securityDomain;
    private final Set<String> declaredRoles = new HashSet<String>();
    private String runAsRole;
    private String runAsPrincipal;
    private SecurityRolesMetaData securityRoles;
    private final Map<String, Collection<String>> securityRoleLinks = new HashMap<String, Collection<String>>();
    private final ApplicableMethodInformation<EJBMethodSecurityAttribute> methodPermissions;
    private final Map<Method, List<AutoTimer>> scheduleMethods = new IdentityHashMap<Method, List<AutoTimer>>();
    private Method timeoutMethod;
    private EJBViewDescription ejbLocalView;
    private EjbHomeViewDescription ejbLocalHomeView;
    private EJBViewDescription ejbRemoteView;
    private EjbHomeViewDescription ejbHomeView;
    private TimerService timerService = NonFunctionalTimerService.INSTANCE;
    private boolean exposedViaIiop = false;
    private final ApplicableMethodInformation<TransactionAttributeType> transactionAttributes;
    private final ApplicableMethodInformation<Integer> transactionTimeouts;

    public EJBComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName) {
        super(componentName, componentClassName, ejbJarDescription.getEEModuleDescription(), deploymentUnitServiceName);
        if (ejbJarDescription.isWar()) {
            this.setNamingMode(ComponentNamingMode.USE_MODULE);
        } else {
            this.setNamingMode(ComponentNamingMode.CREATE);
        }
        this.getConfigurators().addFirst(new NamespaceConfigurator());
        this.getConfigurators().add(new EjbJarConfigurationConfigurator());
        this.addDependency(EJBUtilities.SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
        this.addCurrentInvocationContextFactory();
        this.addRemoteTransactionsRepositoryDependency();
        this.transactionAttributes = new ApplicableMethodInformation<TransactionAttributeType>(componentName, TransactionAttributeType.REQUIRED);
        this.transactionTimeouts = new ApplicableMethodInformation<Object>(componentName, null);
        this.methodPermissions = new ApplicableMethodInformation<Object>(componentName, null);
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                if (description.isTimerServiceApplicable()) {
                    configuration.addTimeoutViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor(configuration.getModuleClassLoder())), 1);
                    configuration.addTimeoutViewInterceptor(configuration.getNamespaceContextInterceptorFactory(), 80);
                    configuration.addTimeoutViewInterceptor(CurrentInvocationContextInterceptor.FACTORY, 1024);
                    if (EJBComponentDescription.this.isSecurityEnabled()) {
                        configuration.addTimeoutViewInterceptor((InterceptorFactory)new SecurityContextInterceptorFactory(), 592);
                    }
                    for (Method method : configuration.getClassIndex().getClassMethods()) {
                        configuration.addTimeoutViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ComponentDispatcherInterceptor(method)), 2560);
                    }
                }
            }
        });
    }

    public void addLocalHome(String localHome) {
        EjbHomeViewDescription view = new EjbHomeViewDescription(this, localHome, MethodIntf.LOCAL_HOME);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.LOCAL_HOME));
        this.getViews().add(view);
        this.setupViewInterceptors(view);
        this.setupClientViewInterceptors(view);
        this.ejbLocalHomeView = view;
    }

    public void addRemoteHome(String remoteHome) {
        EjbHomeViewDescription view = new EjbHomeViewDescription(this, remoteHome, MethodIntf.HOME);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.HOME));
        this.getViews().add(view);
        this.setupViewInterceptors(view);
        this.setupClientViewInterceptors(view);
        this.ejbHomeView = view;
    }

    public void addEjbLocalObjectView(String viewClassName) {
        EJBViewDescription view = this.registerView(viewClassName, MethodIntf.LOCAL, true);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.LOCAL));
        this.ejbLocalView = view;
    }

    public void addEjbObjectView(String viewClassName) {
        EJBViewDescription view = this.registerView(viewClassName, MethodIntf.REMOTE, true);
        view.getConfigurators().add(new Ejb2ViewTypeConfigurator(Ejb2xViewType.REMOTE));
        this.ejbRemoteView = view;
    }

    public TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    public void setTransactionManagementType(TransactionManagementType transactionManagementType) {
        this.transactionManagementType = transactionManagementType;
    }

    public String getEJBName() {
        return this.getComponentName();
    }

    public String getEJBClassName() {
        return this.getComponentClassName();
    }

    protected void setupViewInterceptors(final EJBViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration viewConfiguration) throws DeploymentUnitProcessingException {
                viewConfiguration.addViewInterceptor(LoggingInterceptor.FACTORY, 0);
                viewConfiguration.addViewInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor(componentConfiguration.getModuleClassLoder())), 1);
                if (view.getMethodIntf() == MethodIntf.LOCAL && EJBLocalObject.class.isAssignableFrom(viewConfiguration.getViewClass())) {
                    viewConfiguration.addViewInterceptor(EjbExceptionTransformingInterceptorFactories.LOCAL_INSTANCE, 512);
                } else if (view.getMethodIntf() == MethodIntf.LOCAL_HOME) {
                    viewConfiguration.addViewInterceptor(EjbExceptionTransformingInterceptorFactories.LOCAL_INSTANCE, 512);
                }
            }
        });
        this.addCurrentInvocationContextFactory(view);
        this.setupSecurityInterceptors(view);
        this.setupRemoteViewInterceptors(view);
        view.getConfigurators().addFirst(new NamespaceViewConfigurator());
    }

    private void setupRemoteViewInterceptors(EJBViewDescription view) {
        if (view.getMethodIntf() == MethodIntf.REMOTE || view.getMethodIntf() == MethodIntf.HOME) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    if (Remote.class.isAssignableFrom(configuration.getViewClass())) {
                        configuration.addViewInterceptor(EjbExceptionTransformingInterceptorFactories.REMOTE_INSTANCE, 512);
                    }
                }
            });
            if (view.getMethodIntf() == MethodIntf.HOME) {
                view.getConfigurators().add(new ViewConfigurator(){

                    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                        if (Remote.class.isAssignableFrom(configuration.getViewClass())) {
                            String earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
                            configuration.setViewInstanceFactory((ViewInstanceFactory)new RemoteHomeViewInstanceFactory(earApplicationName, componentConfiguration.getModuleName(), componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName(), componentConfiguration.getComponentName()));
                        }
                    }
                });
            }
            view.getConfigurators().add(new EJBRemoteTransactionsViewConfigurator());
        }
    }

    protected void setupClientViewInterceptors(ViewDescription view) {
        this.addToStringMethodInterceptor(view);
    }

    protected abstract void addCurrentInvocationContextFactory();

    protected abstract void addCurrentInvocationContextFactory(ViewDescription var1);

    protected void addRemoteTransactionsRepositoryDependency() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration componentConfiguration) throws DeploymentUnitProcessingException {
                if (this.hasRemoteView((EJBComponentDescription)description)) {
                    componentConfiguration.getCreateDependencies().add(new DependencyConfigurator<EJBComponentCreateService>(){

                        public void configureDependency(ServiceBuilder<?> serviceBuilder, EJBComponentCreateService ejbComponentCreateService) throws DeploymentUnitProcessingException {
                            serviceBuilder.addDependency(EJBRemoteTransactionsRepository.SERVICE_NAME, EJBRemoteTransactionsRepository.class, ejbComponentCreateService.getEJBRemoteTransactionsRepositoryInjector());
                        }
                    });
                }
            }

            private boolean hasRemoteView(EJBComponentDescription ejbComponentDescription) {
                Set views = ejbComponentDescription.getViews();
                for (ViewDescription view : views) {
                    MethodIntf viewType;
                    if (!(view instanceof EJBViewDescription) || (viewType = ((EJBViewDescription)view).getMethodIntf()) != MethodIntf.REMOTE && viewType != MethodIntf.HOME) continue;
                    return true;
                }
                return false;
            }
        });
    }

    protected void setupSecurityInterceptors(ViewDescription view) {
        view.getConfigurators().add(new EJBSecurityViewConfigurator());
    }

    private void addToStringMethodInterceptor(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                Method TO_STRING_METHOD;
                try {
                    TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new DeploymentUnitProcessingException((Throwable)nsme);
                }
                List methods = configuration.getProxyFactory().getCachedMethods();
                for (Method method : methods) {
                    if (!TO_STRING_METHOD.equals(method)) continue;
                    configuration.addClientInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ToStringMethodInterceptor(EJBComponentDescription.this.getComponentName())), 256);
                    return;
                }
            }
        });
    }

    public boolean isMessageDriven() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isStateful() {
        return false;
    }

    public boolean isStateless() {
        return false;
    }

    public void addDeclaredRoles(String ... roles) {
        this.declaredRoles.addAll(Arrays.asList(roles));
    }

    public void setDeclaredRoles(Collection<String> roles) {
        if (roles == null) {
            throw EjbMessages.MESSAGES.SecurityRolesIsNull();
        }
        this.declaredRoles.clear();
        this.declaredRoles.addAll(roles);
    }

    public Set<String> getDeclaredRoles() {
        return Collections.unmodifiableSet(this.declaredRoles);
    }

    public void setRunAs(String role) {
        this.runAsRole = role;
    }

    public String getRunAs() {
        return this.runAsRole;
    }

    public void setRunAsPrincipal(String principal) {
        this.runAsPrincipal = principal;
    }

    public String getRunAsPrincipal() {
        return this.runAsPrincipal;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public SecurityRolesMetaData getSecurityRoles() {
        return this.securityRoles;
    }

    public void setSecurityRoles(SecurityRolesMetaData securityRoles) {
        this.securityRoles = securityRoles;
    }

    public void linkSecurityRoles(String fromRole, String toRole) {
        if (fromRole == null || fromRole.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.failToLinkFromEmptySecurityRole(fromRole);
        }
        if (toRole == null || toRole.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.failToLinkToEmptySecurityRole(toRole);
        }
        Collection<String> roleLinks = this.securityRoleLinks.get(fromRole);
        if (roleLinks == null) {
            roleLinks = new HashSet<String>();
            this.securityRoleLinks.put(fromRole, roleLinks);
        }
        roleLinks.add(toRole);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodIntf viewType) {
        return this.registerView(viewClassName, viewType, false);
    }

    protected EJBViewDescription registerView(String viewClassName, MethodIntf viewType, boolean ejb2xView) {
        EJBViewDescription viewDescription = new EJBViewDescription(this, viewClassName, viewType, ejb2xView);
        this.getViews().add(viewDescription);
        this.setupViewInterceptors(viewDescription);
        this.setupClientViewInterceptors(viewDescription);
        return viewDescription;
    }

    public Map<String, Collection<String>> getSecurityRoleLinks() {
        return Collections.unmodifiableMap(this.securityRoleLinks);
    }

    public boolean isSecurityEnabled() {
        return this.securityDomain != null;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void setTimerService(TimerService timerService) {
        this.timerService = timerService;
    }

    public EnterpriseBeanMetaData getDescriptorData() {
        return this.descriptorData;
    }

    public void setDescriptorData(EnterpriseBeanMetaData descriptorData) {
        this.descriptorData = descriptorData;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public void setTimeoutMethod(Method timeoutMethod) {
        this.timeoutMethod = timeoutMethod;
    }

    public Map<Method, List<AutoTimer>> getScheduleMethods() {
        return Collections.unmodifiableMap(this.scheduleMethods);
    }

    public void addScheduleMethod(Method method, AutoTimer timer) {
        List<AutoTimer> schedules = this.scheduleMethods.get(method);
        if (schedules == null) {
            schedules = new ArrayList<AutoTimer>(1);
            this.scheduleMethods.put(method, schedules);
        }
        schedules.add(timer);
    }

    public EJBViewDescription getEjbLocalView() {
        return this.ejbLocalView;
    }

    public EjbHomeViewDescription getEjbLocalHomeView() {
        return this.ejbLocalHomeView;
    }

    public EjbHomeViewDescription getEjbHomeView() {
        return this.ejbHomeView;
    }

    public EJBViewDescription getEjbRemoteView() {
        return this.ejbRemoteView;
    }

    public boolean isExposedViaIiop() {
        return this.exposedViaIiop;
    }

    public void setExposedViaIiop(boolean exposedViaIiop) {
        this.exposedViaIiop = exposedViaIiop;
    }

    public ApplicableMethodInformation<TransactionAttributeType> getTransactionAttributes() {
        return this.transactionAttributes;
    }

    public ApplicableMethodInformation<Integer> getTransactionTimeouts() {
        return this.transactionTimeouts;
    }

    public ApplicableMethodInformation<EJBMethodSecurityAttribute> getMethodPermissions() {
        return this.methodPermissions;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{" + "serviceName=" + this.getServiceName() + '}' + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }

    private static class ToStringMethodInterceptor
    implements Interceptor {
        private final String name;

        public ToStringMethodInterceptor(String name) {
            this.name = name;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
            if (componentView == null) {
                throw EjbMessages.MESSAGES.componentViewNotAvailableInContext(context);
            }
            return "Proxy for view class: " + componentView.getViewClass().getName() + " of EJB: " + this.name;
        }
    }

    private class EjbJarConfigurationConfigurator
    implements ComponentConfigurator {
        private EjbJarConfigurationConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            DeploymentUnit deploymentUnit = context.getDeploymentUnit();
            ApplicationExceptions appExceptions = (ApplicationExceptions)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DETAILS);
            if (appExceptions == null) {
                throw EjbMessages.MESSAGES.ejbJarConfigNotFound(deploymentUnit);
            }
            EJBComponentCreateServiceFactory ejbComponentCreateServiceFactory = (EJBComponentCreateServiceFactory)configuration.getComponentCreateServiceFactory();
            ejbComponentCreateServiceFactory.setEjbJarConfiguration(appExceptions);
        }
    }

    private static class Ejb2ViewTypeConfigurator
    implements ViewConfigurator {
        private final Ejb2xViewType local;

        public Ejb2ViewTypeConfigurator(Ejb2xViewType local) {
            this.local = local;
        }

        public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
            configuration.putPrivateData(Ejb2xViewType.class, (Object)this.local);
        }
    }
}

