/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import java.io.Closeable;
import java.io.IOException;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.TransactionRequestHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;
import org.xnio.IoUtils;

class XidTransactionPrepareTask
extends XidTransactionManagementTask {
    private static final Logger logger = Logger.getLogger(XidTransactionPrepareTask.class);

    XidTransactionPrepareTask(TransactionRequestHandler txRequestHandler, EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, XidTransactionID xidTransactionID, Channel channel, short invocationId) {
        super(txRequestHandler, transactionsRepository, marshallerFactory, xidTransactionID, channel, invocationId);
    }

    @Override
    public void run() {
        try {
            this.manageTransaction();
        }
        catch (Throwable t) {
            try {
                this.transactionRequestHandler.writeException(this.channel, this.marshallerFactory, this.invocationId, t, null);
            }
            catch (IOException e) {
                logger.error((Object)"Could not write out message to channel due to", (Throwable)e);
                IoUtils.safeClose((Closeable)this.channel);
            }
            return;
        }
    }

    @Override
    protected void manageTransaction() throws Throwable {
        int prepareResult = this.prepareTransaction();
        try {
            this.transactionRequestHandler.writeTxPrepareResponseMessage(this.channel, this.invocationId, prepareResult);
        }
        catch (IOException e) {
            logger.error((Object)"Could not write out invocation success message to channel due to", (Throwable)e);
            IoUtils.safeClose((Closeable)this.channel);
        }
    }

    private int prepareTransaction() throws Throwable {
        Transaction transaction = this.transactionsRepository.removeTransaction((TransactionID)this.xidTransactionID);
        this.resumeTransaction(transaction);
        try {
            Xid xid = this.xidTransactionID.getXid();
            SubordinateTransaction subordinateTransaction = SubordinationManager.getTransactionImporter().getImportedTransaction(xid);
            int result = subordinateTransaction.doPrepare();
            switch (result) {
                case 2: {
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                    int n = 3;
                    return n;
                }
                case 0: {
                    int n = 0;
                    return n;
                }
                case 1: {
                    Throwable initCause = null;
                    int xaExceptionCode = 100;
                    try {
                        subordinateTransaction.doRollback();
                    }
                    catch (HeuristicCommitException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    catch (HeuristicMixedException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    catch (SystemException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    catch (HeuristicRollbackException e) {
                        initCause = e;
                        xaExceptionCode = -3;
                    }
                    SubordinationManager.getTransactionImporter().removeImportedTransaction(xid);
                    XAException xaException = new XAException(xaExceptionCode);
                    if (initCause != null) {
                        xaException.initCause(initCause);
                    }
                    throw xaException;
                }
                case 11: {
                    throw new XAException(-4);
                }
            }
            throw new XAException(104);
        }
        finally {
            this.transactionsRepository.getTransactionManager().suspend();
        }
    }
}

