/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.filestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class FileTimerPersistence
implements TimerPersistence,
Service<FileTimerPersistence> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb3", "timerService", "fileTimerPersistence"});
    private final boolean createIfNotExists;
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();
    private final InjectedValue<String> baseDir = new InjectedValue();
    private final ConcurrentMap<String, Map<String, TimerEntity>> timers = new ConcurrentHashMap<String, Map<String, TimerEntity>>();
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>();
    private final ConcurrentMap<String, String> directories = new ConcurrentHashMap<String, String>();
    private volatile boolean started = false;

    public FileTimerPersistence(boolean createIfNotExists) {
        this.createIfNotExists = createIfNotExists;
    }

    public synchronized void start(StartContext context) {
        RiverMarshallerFactory factory = new RiverMarshallerFactory();
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.moduleLoader.getValue())));
        this.configuration = configuration;
        this.factory = factory;
        File baseDir = new File((String)this.baseDir.getValue());
        if (!baseDir.exists()) {
            if (this.createIfNotExists) {
                if (!baseDir.mkdirs()) {
                    throw EjbMessages.MESSAGES.failToCreateTimerFileStoreDir(baseDir);
                }
            } else {
                throw EjbMessages.MESSAGES.timerFileStoreDirNotExist(baseDir);
            }
        }
        if (!baseDir.isDirectory()) {
            throw EjbMessages.MESSAGES.invalidTimerFileStoreDir(baseDir);
        }
        this.started = true;
    }

    public void stop(StopContext context) {
        this.timers.clear();
        this.locks.clear();
        this.directories.clear();
        this.factory = null;
        this.configuration = null;
        this.started = false;
    }

    public FileTimerPersistence getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistTimer(TimerEntity timerEntity) {
        block10: {
            Lock lock = this.getLock(timerEntity.getTimedObjectId());
            try {
                int status = ((TransactionManager)this.transactionManager.getValue()).getStatus();
                if (status == 1 || status == 4 || status == 9) {
                    return;
                }
                if (status == 6 || status == 5 || this.isBeforeCompletion() || status == 3) {
                    try {
                        lock.lock();
                        Map<String, TimerEntity> map = this.getTimers(timerEntity.getTimedObjectId());
                        if (timerEntity.getTimerState() == TimerState.CANCELED || timerEntity.getTimerState() == TimerState.EXPIRED) {
                            map.remove(timerEntity.getId());
                        } else {
                            map.put(timerEntity.getId(), timerEntity);
                        }
                        this.writeFile(timerEntity);
                        break block10;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                String key = this.timerTransactionKey(timerEntity);
                Object existing = ((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).getResource((Object)key);
                if (existing == null) {
                    ((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).registerInterposedSynchronization((Synchronization)new PersistTransactionSynchronization(lock, key));
                }
                ((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).putResource((Object)key, (Object)timerEntity);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String timerTransactionKey(TimerEntity timerEntity) {
        return "org.jboss.as.ejb3.timerTransactionKey." + timerEntity.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerUndeployed(String timedObjectId) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            this.locks.remove(timedObjectId);
            this.timers.remove(timedObjectId);
            this.directories.remove(timedObjectId);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isBeforeCompletion() {
        CurrentSynchronizationCallback.CallbackType type = CurrentSynchronizationCallback.get();
        if (type != null) {
            return type == CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimerEntity loadTimer(String id, String timedObjectId) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            Map<String, TimerEntity> timers = this.getTimers(timedObjectId);
            TimerEntity timer = timers.get(id);
            if (timer == null) {
                TimerEntity timerEntity = null;
                return timerEntity;
            }
            TimerEntity timerEntity = this.mostRecentEntityVersion(timer);
            return timerEntity;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TimerEntity> loadActiveTimers(String timedObjectId, Object primaryKey) {
        Lock lock = this.getLock(timedObjectId);
        try {
            lock.lock();
            Map<String, TimerEntity> timers = this.getTimers(timedObjectId);
            ArrayList<TimerEntity> entities = new ArrayList<TimerEntity>();
            for (Map.Entry<String, TimerEntity> entry : timers.entrySet()) {
                if (primaryKey != null && !primaryKey.equals(entry.getValue().getPrimaryKey())) continue;
                entities.add(this.mostRecentEntityVersion(entry.getValue()));
            }
            ArrayList<TimerEntity> arrayList = entities;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public List<TimerEntity> loadActiveTimers(String timedObjectId) {
        return this.loadActiveTimers(timedObjectId, null);
    }

    private TimerEntity mostRecentEntityVersion(TimerEntity timerEntity) {
        try {
            int status = ((TransactionManager)this.transactionManager.getValue()).getStatus();
            if (status == 5 || status == 6) {
                return timerEntity;
            }
            String key = this.timerTransactionKey(timerEntity);
            TimerEntity existing = (TimerEntity)((TransactionSynchronizationRegistry)this.transactionSynchronizationRegistry.getValue()).getResource((Object)key);
            return existing != null ? existing : timerEntity;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    private Lock getLock(String timedObjectId) {
        ReentrantLock addedLock;
        Lock lock = (Lock)this.locks.get(timedObjectId);
        if (lock == null && (lock = this.locks.putIfAbsent(timedObjectId, addedLock = new ReentrantLock())) == null) {
            lock = addedLock;
        }
        return lock;
    }

    private Map<String, TimerEntity> getTimers(String timedObjectId) {
        Map<String, TimerEntity> map = (Map<String, TimerEntity>)this.timers.get(timedObjectId);
        if (map == null) {
            map = this.loadTimersFromFile(timedObjectId);
            this.timers.put(timedObjectId, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TimerEntity> loadTimersFromFile(String timedObjectId) {
        HashMap<String, TimerEntity> timers = new HashMap<String, TimerEntity>();
        try {
            File file = new File(this.getDirectory(timedObjectId));
            if (!file.exists()) {
                return timers;
            }
            if (!file.isDirectory()) {
                EjbLogger.ROOT_LOGGER.failToRestoreTimers(file);
                return timers;
            }
            Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);
            for (File timerFile : file.listFiles()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(timerFile);
                    unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)in));
                    TimerEntity entity = (TimerEntity)unmarshaller.readObject(TimerEntity.class);
                    timers.put(entity.getId(), entity);
                    unmarshaller.finish();
                }
                catch (Exception e) {
                    EjbLogger.ROOT_LOGGER.failToRestoreTimersFromFile(timerFile, e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            EjbLogger.ROOT_LOGGER.failToCloseFile(e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            EjbLogger.ROOT_LOGGER.failToRestoreTimersForObjectId(timedObjectId, e);
        }
        return timers;
    }

    private File fileName(String timedObjectId, String timerId) {
        return new File(this.getDirectory(timedObjectId) + File.separator + timerId.replace(File.separator, "-"));
    }

    private String getDirectory(String timedObjectId) {
        String dirName = (String)this.directories.get(timedObjectId);
        if (dirName == null) {
            File baseDir = new File((String)this.baseDir.getValue());
            dirName = baseDir.getAbsolutePath() + File.separator + timedObjectId.replace(File.separator, "-");
            File file = new File(dirName);
            if (!file.exists() && !file.mkdirs()) {
                EjbLogger.ROOT_LOGGER.failToCreateDirectoryForPersistTimers(file);
            }
            this.directories.put(timedObjectId, dirName);
        }
        return dirName;
    }

    private void writeFile(TimerEntity entity) {
        File file = this.fileName(entity.getTimedObjectId(), entity.getId());
        if (entity.getTimerState() == TimerState.CANCELED || entity.getTimerState() == TimerState.EXPIRED) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, false);
            Marshaller marshaller = this.factory.createMarshaller(this.configuration);
            marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)fileOutputStream));
            marshaller.writeObject((Object)entity);
            marshaller.finish();
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    EjbLogger.ROOT_LOGGER.failToCloseFile(e);
                }
            }
        }
    }

    public InjectedValue<TransactionManager> getTransactionManager() {
        return this.transactionManager;
    }

    public InjectedValue<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    public InjectedValue<ModuleLoader> getModuleLoader() {
        return this.moduleLoader;
    }

    public InjectedValue<String> getBaseDir() {
        return this.baseDir;
    }

    private final class PersistTransactionSynchronization
    implements Synchronization {
        private final String transactionKey;
        private final Lock lock;
        private volatile TimerEntity timer;

        public PersistTransactionSynchronization(Lock lock, String transactionKey) {
            this.lock = lock;
            this.transactionKey = transactionKey;
        }

        public void beforeCompletion() {
            this.timer = (TimerEntity)((TransactionSynchronizationRegistry)FileTimerPersistence.this.transactionSynchronizationRegistry.getValue()).getResource((Object)this.transactionKey);
            if (this.timer == null) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (this.timer == null) {
                return;
            }
            try {
                this.lock.lock();
                if (status == 3) {
                    Map map = FileTimerPersistence.this.getTimers(this.timer.getTimedObjectId());
                    if (this.timer.getTimerState() == TimerState.CANCELED || this.timer.getTimerState() == TimerState.EXPIRED) {
                        map.remove(this.timer.getId());
                    } else {
                        map.put(this.timer.getId(), this.timer);
                    }
                    FileTimerPersistence.this.writeFile(this.timer);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

