/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentDescription;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
import org.jboss.msc.value.InjectedValue;

public class EntityBeanComponentCreateService
extends EJBComponentCreateService {
    private final Class<EJBHome> homeClass;
    private final Class<EJBLocalHome> localHomeClass;
    private final Class<EJBObject> remoteClass;
    private final Class<EJBLocalObject> localClass;
    private final Class<Object> primaryKeyClass;
    private final Method ejbStoreMethod;
    private final Method ejbLoadMethod;
    private final Method ejbActivateMethod;
    private final Method ejbPassivateMethod;
    private final Method unsetEntityContextMethod;
    private final InterceptorFactory ejbStore;
    private final InterceptorFactory ejbLoad;
    private final InterceptorFactory ejbActivate;
    private final InterceptorFactory ejbPassivate;
    private final InterceptorFactory unsetEntityContext;
    private final InjectedValue<PoolConfig> poolConfig = new InjectedValue();
    private final InjectedValue<Boolean> defaultOptimisticLocking = new InjectedValue();
    public static final ComponentCreateServiceFactory FACTORY = new EJBComponentCreateServiceFactory(){

        public BasicComponentCreateService constructService(ComponentConfiguration configuration) {
            return new EntityBeanComponentCreateService(configuration, this.ejbJarConfiguration);
        }
    };

    public EntityBeanComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        EntityBeanComponentDescription description = (EntityBeanComponentDescription)((Object)EntityBeanComponentDescription.class.cast(componentConfiguration.getComponentDescription()));
        EntityBeanMetaData beanMetaData = (EntityBeanMetaData)EntityBeanMetaData.class.cast(description.getDescriptorData());
        ClassLoader classLoader = componentConfiguration.getComponentClass().getClassLoader();
        this.homeClass = this.load(classLoader, beanMetaData.getHome());
        this.localHomeClass = this.load(classLoader, beanMetaData.getLocalHome());
        this.localClass = this.load(classLoader, beanMetaData.getLocal());
        this.remoteClass = this.load(classLoader, beanMetaData.getRemote());
        this.primaryKeyClass = this.load(classLoader, beanMetaData.getPrimKeyClass());
        ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor(componentConfiguration.getModuleClassLoader()));
        InterceptorFactory namespaceContextInterceptorFactory = componentConfiguration.getNamespaceContextInterceptorFactory();
        Method ejbStore = null;
        Method ejbLoad = null;
        Method ejbActivate = null;
        Method ejbPassivate = null;
        Method unsetEntityContext = null;
        for (Method method : componentConfiguration.getDefinedComponentMethods()) {
            if (method.getName().equals("ejbStore") && method.getParameterTypes().length == 0) {
                ejbStore = method;
                continue;
            }
            if (method.getName().equals("ejbLoad") && method.getParameterTypes().length == 0) {
                ejbLoad = method;
                continue;
            }
            if (method.getName().equals("ejbActivate") && method.getParameterTypes().length == 0) {
                ejbActivate = method;
                continue;
            }
            if (method.getName().equals("ejbPassivate") && method.getParameterTypes().length == 0) {
                ejbPassivate = method;
                continue;
            }
            if (!method.getName().equals("unsetEntityContext") || method.getParameterTypes().length != 0) continue;
            unsetEntityContext = method;
        }
        if (ejbStore == null) {
            throw EjbMessages.MESSAGES.couldNotFindEntityBeanMethod("ejbStore");
        }
        if (ejbLoad == null) {
            throw EjbMessages.MESSAGES.couldNotFindEntityBeanMethod("ejbLoad");
        }
        if (ejbActivate == null) {
            throw EjbMessages.MESSAGES.couldNotFindEntityBeanMethod("ejbActivate");
        }
        if (ejbPassivate == null) {
            throw EjbMessages.MESSAGES.couldNotFindEntityBeanMethod("ejbPassivate");
        }
        if (unsetEntityContext == null) {
            throw EjbMessages.MESSAGES.couldNotFindEntityBeanMethod("unsetEntityContext");
        }
        this.ejbActivateMethod = ejbActivate;
        this.ejbLoadMethod = ejbLoad;
        this.ejbStoreMethod = ejbStore;
        this.ejbPassivateMethod = ejbPassivate;
        this.unsetEntityContextMethod = unsetEntityContext;
        this.ejbActivate = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, EntityBeanComponentCreateService.invokeMethodOnTarget(ejbActivate)});
        this.ejbLoad = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, EntityBeanComponentCreateService.invokeMethodOnTarget(ejbLoad)});
        this.ejbStore = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, EntityBeanComponentCreateService.invokeMethodOnTarget(ejbStore)});
        this.ejbPassivate = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, EntityBeanComponentCreateService.invokeMethodOnTarget(ejbPassivate)});
        this.unsetEntityContext = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, EntityBeanComponentCreateService.invokeMethodOnTarget(unsetEntityContext)});
    }

    private Class<?> load(ClassLoader classLoader, String ejbClass) {
        if (ejbClass != null) {
            try {
                return classLoader.loadClass(ejbClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to load component view class: " + ejbClass, e);
            }
        }
        return null;
    }

    private static InterceptorFactory invokeMethodOnTarget(Method method) {
        method.setAccessible(true);
        return InvokeMethodOnTargetInterceptor.factory(method);
    }

    protected BasicComponent createComponent() {
        return new EntityBeanComponent(this);
    }

    public Class<EJBHome> getHomeClass() {
        return this.homeClass;
    }

    public Class<EJBLocalHome> getLocalHomeClass() {
        return this.localHomeClass;
    }

    public Class<EJBObject> getRemoteClass() {
        return this.remoteClass;
    }

    public Class<EJBLocalObject> getLocalClass() {
        return this.localClass;
    }

    public Class<Object> getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public Method getEjbStoreMethod() {
        return this.ejbStoreMethod;
    }

    public Method getEjbLoadMethod() {
        return this.ejbLoadMethod;
    }

    public Method getEjbActivateMethod() {
        return this.ejbActivateMethod;
    }

    public InterceptorFactory getEjbStore() {
        return this.ejbStore;
    }

    public InterceptorFactory getEjbLoad() {
        return this.ejbLoad;
    }

    public InterceptorFactory getEjbActivate() {
        return this.ejbActivate;
    }

    public Method getEjbPassivateMethod() {
        return this.ejbPassivateMethod;
    }

    public InterceptorFactory getEjbPassivate() {
        return this.ejbPassivate;
    }

    public Method getUnsetEntityContextMethod() {
        return this.unsetEntityContextMethod;
    }

    public InterceptorFactory getUnsetEntityContext() {
        return this.unsetEntityContext;
    }

    public PoolConfig getPoolConfig() {
        return (PoolConfig)this.poolConfig.getOptionalValue();
    }

    public InjectedValue<PoolConfig> getPoolConfigInjector() {
        return this.poolConfig;
    }

    public Boolean getOptimisticLocking() {
        return (Boolean)this.defaultOptimisticLocking.getOptionalValue();
    }

    public InjectedValue<Boolean> getOptimisticLockingInjector() {
        return this.defaultOptimisticLocking;
    }
}

