/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.spi.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.spi.BackingCache;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntry;
import org.jboss.as.ejb3.cache.spi.BackingCacheLifecycleListener;
import org.jboss.logging.Logger;

public abstract class AbstractBackingCache<K extends Serializable, V extends Cacheable<K>, E extends BackingCacheEntry<K, V>>
implements BackingCache<K, V, E> {
    protected Logger log = Logger.getLogger((String)this.getClass().getName());
    private final Set<BackingCacheLifecycleListener> listeners = new HashSet<BackingCacheLifecycleListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(BackingCacheLifecycleListener listener) {
        Set<BackingCacheLifecycleListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(BackingCacheLifecycleListener listener) {
        Set<BackingCacheLifecycleListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLifecycleListeners(BackingCacheLifecycleListener.LifecycleState newState) {
        Set<BackingCacheLifecycleListener> set = this.listeners;
        synchronized (set) {
            for (BackingCacheLifecycleListener listener : this.listeners) {
                try {
                    listener.lifecycleChange(newState);
                }
                catch (RuntimeException e) {
                    this.log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

