/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;

public class ApplicationExceptions {
    private final Map<Class<?>, ApplicationExceptionDetails> applicationExceptions = new HashMap();

    public ApplicationExceptionDetails getApplicationException(Class<?> exceptionClass) {
        return this.applicationExceptions.get(exceptionClass);
    }

    public Map<Class<?>, ApplicationExceptionDetails> getApplicationExceptions() {
        return Collections.unmodifiableMap(this.applicationExceptions);
    }

    public void addApplicationException(Class<?> exceptionClass, ApplicationExceptionDetails applicationException) {
        if (exceptionClass == null) {
            throw EjbMessages.MESSAGES.paramCannotBeNull("Exception class");
        }
        if (applicationException == null) {
            throw EjbMessages.MESSAGES.paramCannotBeNull("ApplicationException");
        }
        if (!Exception.class.isAssignableFrom(exceptionClass)) {
            throw EjbMessages.MESSAGES.cannotBeApplicationExceptionBecauseNotAnExceptionType(exceptionClass);
        }
        if (RemoteException.class.isAssignableFrom(exceptionClass)) {
            throw EjbMessages.MESSAGES.rmiRemoteExceptionCannotBeApplicationException(exceptionClass);
        }
        this.applicationExceptions.put(exceptionClass, applicationException);
    }
}

