/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDependencyProcessor;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.JaxrsIntegrationProcessor;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.moduleservice.ModuleIndexService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrapClasses;

public class JaxrsScanningProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.jaxrs");
    public static final DotName APPLICATION = DotName.createSimple((String)Application.class.getName());
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServiceController serviceController = phaseContext.getServiceRegistry().getRequiredService(Services.JBOSS_MODULE_INDEX_SERVICE);
        try {
            this.scan(deploymentUnit, warMetaData.getMergedJBossWebMetaData(), (ClassLoader)module.getClassLoader(), (ModuleIndexService)serviceController.getValue());
        }
        catch (ModuleLoadException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected boolean hasBootClasses(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentUnitProcessingException {
        if (webdata.getServlets() != null) {
            for (JBossServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return true;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected void scan(DeploymentUnit du, JBossWebMetaData webdata, ClassLoader classLoader, ModuleIndexService moduleIndexService) throws DeploymentUnitProcessingException, ModuleLoadException {
        ClassInfo info;
        List contextParams;
        ResteasyDeploymentData resteasyDeploymentData = new ResteasyDeploymentData();
        du.putAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA, (Object)resteasyDeploymentData);
        ServiceModuleLoader moduleLoader = (ServiceModuleLoader)du.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        Module resteasy = moduleLoader.loadModule(JaxrsDependencyProcessor.RESTEASY_JAXRS);
        CompositeIndex resteastAnnotations = moduleIndexService.getIndex(resteasy);
        boolean hasBoot = this.hasBootClasses(du, webdata);
        resteasyDeploymentData.setBootClasses(hasBoot);
        CompositeIndex deploymentIndex = (CompositeIndex)du.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        CompositeIndex index = new CompositeIndex(new CompositeIndex[]{deploymentIndex, resteastAnnotations});
        Class<?> declaredApplicationClass = this.checkDeclaredApplicationClassAsServlet(du, webdata, classLoader);
        if (declaredApplicationClass != null) {
            resteasyDeploymentData.setDispatcherCreated(true);
        }
        if (!hasBoot && !webdata.isMetadataComplete()) {
            resteasyDeploymentData.setScanAll(true);
            resteasyDeploymentData.setScanProviders(true);
            resteasyDeploymentData.setScanResources(true);
        }
        if ((contextParams = webdata.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals("resteasy.scan")) {
                    resteasyDeploymentData.setScanAll(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.providers")) {
                    resteasyDeploymentData.setScanProviders(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.resources")) {
                    resteasyDeploymentData.setScanResources(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (!param.getParamName().equals("resteasy.unwrapped.exceptions")) continue;
                resteasyDeploymentData.setUnwrappedExceptionsParameterSet(true);
            }
        }
        if (!resteasyDeploymentData.shouldScan()) {
            return;
        }
        if (declaredApplicationClass == null) {
            Set applicationClass = index.getAllKnownSubclasses(APPLICATION);
            try {
                if (applicationClass.size() > 1) {
                    StringBuilder builder = new StringBuilder("Only one JAX-RS Application Class allowed.");
                    HashSet<ClassInfo> aClasses = new HashSet<ClassInfo>();
                    for (ClassInfo c : applicationClass) {
                        if (!Modifier.isAbstract(c.flags())) {
                            aClasses.add(c);
                        }
                        builder.append(" ").append(c.name().toString());
                    }
                    if (aClasses.size() > 1) {
                        throw new DeploymentUnitProcessingException(builder.toString());
                    }
                    if (aClasses.size() == 1) {
                        ClassInfo aClass = (ClassInfo)applicationClass.iterator().next();
                        resteasyDeploymentData.setScannedApplicationClass(classLoader.loadClass(aClass.name().toString()));
                    }
                } else if (applicationClass.size() == 1) {
                    ClassInfo aClass = (ClassInfo)applicationClass.iterator().next();
                    resteasyDeploymentData.setScannedApplicationClass(classLoader.loadClass(aClass.name().toString()));
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Could not load JAX-RS Application class:", (Throwable)e);
            }
        }
        List resources = null;
        List providers = null;
        if (resteasyDeploymentData.isScanResources()) {
            resources = index.getAnnotations(JaxrsAnnotations.PATH.getDotName());
        }
        if (resteasyDeploymentData.isScanProviders()) {
            providers = index.getAnnotations(JaxrsAnnotations.PROVIDER.getDotName());
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        HashSet<ClassInfo> pathInterfaces = new HashSet<ClassInfo>();
        if (resources != null) {
            for (AnnotationInstance e : resources) {
                if (e.target() instanceof ClassInfo) {
                    info = (ClassInfo)e.target();
                } else if (e.target() instanceof MethodInfo) {
                    info = ((MethodInfo)e.target()).declaringClass();
                } else {
                    log.warnf("@Path annotation not on Class or Method: %s", (Object)e.target());
                    continue;
                }
                if (!Modifier.isInterface(info.flags())) {
                    resteasyDeploymentData.getScannedResourceClasses().add(info.name().toString());
                    continue;
                }
                pathInterfaces.add(info);
            }
        }
        if (providers != null) {
            for (AnnotationInstance e : providers) {
                if (e.target() instanceof ClassInfo) {
                    info = (ClassInfo)e.target();
                    if (Modifier.isInterface(info.flags())) continue;
                    resteasyDeploymentData.getScannedProviderClasses().add(info.name().toString());
                    continue;
                }
                log.warnf("@Provider annotation not on Class: %s", (Object)e.target());
            }
        }
        for (ClassInfo iface : pathInterfaces) {
            Set implementors = index.getAllKnownImplementors(iface.name());
            for (ClassInfo implementor : implementors) {
                resteasyDeploymentData.getScannedResourceClasses().add(implementor.name().toString());
            }
        }
    }

    protected Class<?> checkDeclaredApplicationClassAsServlet(DeploymentUnit du, JBossWebMetaData webdata, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        if (webdata.getServlets() == null) {
            return null;
        }
        for (JBossServletMetaData servlet : webdata.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("javax.ws.rs.Application");
            param.setParamValue(servletClass);
            ArrayList<ParamValueMetaData> params = servlet.getInitParam();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(params);
            }
            params.add(param);
            try {
                classLoader.loadClass("org.jboss.resteasy.cdi.CdiInjectorFactory");
                if (WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)du)) {
                    JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.injector.factory", "org.jboss.resteasy.cdi.CdiInjectorFactory");
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            return clazz;
        }
        return null;
    }

    static {
        for (String clazz : ResteasyBootstrapClasses.BOOTSTRAP_CLASSES) {
            BOOT_CLASSES.add(clazz);
        }
    }
}

