/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.resteasy.util.GetRestful;

public class JaxrsComponentDeployer
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.jaxrs");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        if (!resteasy.isScanResources()) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ModuleClassLoader loader = module.getClassLoader();
        for (AbstractComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof ManagedBeanComponentDescription)) continue;
            Class<?> componentClass = null;
            try {
                componentClass = loader.loadClass(component.getComponentClassName());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
            if (!GetRestful.isRootResource(componentClass)) continue;
            String jndiName = "java:module/" + component.getComponentName();
            log.debug((Object)("Found JAX-RS Managed Bean: " + component.getComponentClassName() + " local jndi name: " + jndiName));
            StringBuilder buf = new StringBuilder();
            buf.append(jndiName).append(";").append(component.getComponentClassName()).append(";").append("true");
            resteasy.getScannedJndiComponentResources().add(buf.toString());
            resteasy.getScannedResourceClasses().remove(component.getComponentClassName());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

