/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class JaxrsDependencyProcessor
implements DeploymentUnitProcessor {
    public static ModuleIdentifier RESTEASY_JAXRS = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxrs");
    public static ModuleIdentifier RESTEASY_JAXB = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-jaxb-provider");
    public static ModuleIdentifier ASYNC_HTTP_SERVLET_30 = ModuleIdentifier.create((String)"org.jboss.resteasy.async-http-servlet-30");
    public static ModuleIdentifier RESTEASY_CDI = ModuleIdentifier.create((String)"org.jboss.resteasy.resteasy-cdi");
    public static ModuleIdentifier JAXB_API = ModuleIdentifier.create((String)"javax.xml.bind.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_JAXRS);
        this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_JAXB);
        this.addDepdenency(moduleSpecification, moduleLoader, JAXB_API);
        this.addDepdenency(moduleSpecification, moduleLoader, ASYNC_HTTP_SERVLET_30);
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            this.addDepdenency(moduleSpecification, moduleLoader, RESTEASY_CDI);
        }
    }

    private void addDepdenency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

