/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jdr.JdrReportDescriptions;
import org.jboss.as.jdr.JdrReportRequestHandler;
import org.jboss.as.jdr.JdrReportSubsystemAdd;
import org.jboss.as.jdr.JdrReportSubsystemParser;
import org.jboss.as.jdr.JdrReportSubsystemRemove;
import org.jboss.as.jdr.Namespace;
import org.jboss.as.threads.ThreadsDescriptionUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JdrReportExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jdr";

    public void initialize(ExtensionContext context) {
        DescriptionProvider subsystemDescription = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return JdrReportDescriptions.getJdrSubsystemDescription(locale);
            }
        };
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration root = subsystemRegistration.registerSubsystemModel(subsystemDescription);
        root.registerOperationHandler("add", (OperationStepHandler)JdrReportSubsystemAdd.INSTANCE, (DescriptionProvider)JdrReportSubsystemAdd.INSTANCE);
        root.registerOperationHandler("describe", (OperationStepHandler)JdrSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)JdrSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        root.registerOperationHandler("remove", (OperationStepHandler)JdrReportSubsystemRemove.INSTANCE, (DescriptionProvider)JdrReportSubsystemRemove.INSTANCE);
        root.registerOperationHandler("generate-jdr-report", (OperationStepHandler)JdrReportRequestHandler.INSTANCE, (DescriptionProvider)JdrReportRequestHandler.INSTANCE);
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)JdrReportSubsystemParser.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)JdrReportSubsystemParser.INSTANCE);
    }

    private static class JdrSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final JdrSubsystemDescribeHandler INSTANCE = new JdrSubsystemDescribeHandler();

        private JdrSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            result.add(Util.getEmptyOperation((String)"add", (ModelNode)ThreadsDescriptionUtil.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)JdrReportExtension.SUBSYSTEM_NAME)})));
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }
}

