/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JdrReportDescriptions {
    private static final String RESOURCE_NAME = JdrReportDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getJdrSubsystemDescription(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("description").set(bundle2.getString("jdr.subsystem"));
        return result;
    }

    public static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("add");
        result.get("description").set(bundle2.getString("jdr.add"));
        result.get("request-properties").setEmptyObject();
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    public static ModelNode getSubsystemRemove(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("remove");
        result.get("description").set(bundle2.getString("jdr.remove"));
        result.get("request-properties").setEmptyObject();
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    public static ModelNode getJdrRequestDescription(Locale locale) {
        ResourceBundle bundle2 = JdrReportDescriptions.getResourceBundle(locale);
        ModelNode result = new ModelNode();
        result.get("operation-name").set("generate-jdr-report");
        result.get("description").set(bundle2.getString("jdr.request"));
        result.get("request-properties").setEmptyObject();
        result.get(new String[]{"reply-properties", "description"}).set("jdr.report.return");
        result.get(new String[]{"reply-properties", "type"}).set(ModelType.OBJECT);
        result.get(new String[]{"reply-properties", "value-type", "start-time", "description"}).set(bundle2.getString("jdr.report.return.starttime"));
        result.get(new String[]{"reply-properties", "value-type", "start-time", "type"}).set(ModelType.STRING);
        result.get(new String[]{"reply-properties", "value-type", "start-time", "required"}).set(true);
        result.get(new String[]{"reply-properties", "value-type", "end-time", "description"}).set(bundle2.getString("jdr.report.return.endtime"));
        result.get(new String[]{"reply-properties", "value-type", "end-time", "type"}).set(ModelType.STRING);
        result.get(new String[]{"reply-properties", "value-type", "end-time", "required"}).set(true);
        result.get(new String[]{"reply-properties", "value-type", "report-location", "description"}).set(bundle2.getString("jdr.report.return.location"));
        result.get(new String[]{"reply-properties", "value-type", "report-location", "type"}).set(ModelType.STRING);
        result.get(new String[]{"reply-properties", "value-type", "report-location", "required"}).set(false);
        return result;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

