/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.util.EnumSet;
import java.util.Locale;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jdr.JdrReportDescriptions;
import org.jboss.as.jdr.JdrReportRequestHandler;
import org.jboss.as.jdr.JdrReportSubsystemAdd;
import org.jboss.as.jdr.JdrReportSubsystemParser;
import org.jboss.as.jdr.JdrReportSubsystemRemove;
import org.jboss.as.jdr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JdrReportExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jdr";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 0;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    public void initialize(ExtensionContext context) {
        DescriptionProvider subsystemDescription = new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return JdrReportDescriptions.getJdrSubsystemDescription(locale);
            }
        };
        SubsystemRegistration subsystemRegistration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 0, 0);
        ManagementResourceRegistration root = subsystemRegistration.registerSubsystemModel(subsystemDescription);
        root.registerOperationHandler("add", (OperationStepHandler)JdrReportSubsystemAdd.INSTANCE, (DescriptionProvider)JdrReportSubsystemAdd.INSTANCE);
        root.registerOperationHandler("describe", (OperationStepHandler)JdrSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)JdrSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        root.registerOperationHandler("remove", (OperationStepHandler)JdrReportSubsystemRemove.INSTANCE, (DescriptionProvider)JdrReportSubsystemRemove.INSTANCE);
        if (context.isRuntimeOnlyRegistrationValid()) {
            root.registerOperationHandler("generate-jdr-report", (OperationStepHandler)JdrReportRequestHandler.INSTANCE, (DescriptionProvider)JdrReportRequestHandler.INSTANCE, EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY));
        }
        subsystemRegistration.registerXMLElementWriter((XMLElementWriter)JdrReportSubsystemParser.INSTANCE);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.CURRENT.getUriString(), (XMLElementReader)JdrReportSubsystemParser.INSTANCE);
    }

    private static ModelNode pathAddress(PathElement ... elements) {
        return PathAddress.pathAddress((PathElement[])elements).toModelNode();
    }

    private static class JdrSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final JdrSubsystemDescribeHandler INSTANCE = new JdrSubsystemDescribeHandler();

        private JdrSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            result.add(Util.getEmptyOperation((String)"add", (ModelNode)JdrReportExtension.pathAddress(new PathElement[]{PathElement.pathElement((String)"subsystem", (String)JdrReportExtension.SUBSYSTEM_NAME)})));
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }
}

