/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.jmx.JMXConnectorElement;
import org.jboss.as.jmx.JMXConnectorRemove;
import org.jboss.as.jmx.JMXConnectorService;
import org.jboss.as.jmx.JmxSubsystemElement;
import org.jboss.as.jmx.Namespace;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.ServiceListener;

public class JMXConnectorAdd
extends AbstractSubsystemUpdate<JmxSubsystemElement, Void> {
    private static final long serialVersionUID = -1898250436998656765L;
    private String serverBinding;
    private String registryBinding;

    public JMXConnectorAdd(String serverBinding, String registryBinding) {
        super(Namespace.CURRENT.getUriString());
        if (serverBinding == null) {
            throw new IllegalArgumentException("null connector binding");
        }
        if (registryBinding == null) {
            throw new IllegalArgumentException("null registry binding");
        }
        this.serverBinding = serverBinding;
        this.registryBinding = registryBinding;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder builder = updateContext.getBatchBuilder();
        JMXConnectorService.addService(builder, this.serverBinding, this.registryBinding).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param));
    }

    public AbstractSubsystemUpdate<JmxSubsystemElement, ?> getCompensatingUpdate(JmxSubsystemElement original) {
        return new JMXConnectorRemove();
    }

    public Class<JmxSubsystemElement> getModelElementType() {
        return JmxSubsystemElement.class;
    }

    protected void applyUpdate(JmxSubsystemElement element) throws UpdateFailedException {
        element.setConnector(new JMXConnectorElement(this.serverBinding, this.registryBinding));
    }
}

