/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.jmx.JMXConnectorAdd;
import org.jboss.as.jmx.JMXConnectorElement;
import org.jboss.as.jmx.JMXConnectorService;
import org.jboss.as.jmx.JmxSubsystemElement;
import org.jboss.as.jmx.Namespace;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class JMXConnectorRemove
extends AbstractSubsystemUpdate<JmxSubsystemElement, Void> {
    private static final long serialVersionUID = 5839017395274175195L;

    protected JMXConnectorRemove() {
        super(Namespace.CURRENT.getUriString());
    }

    protected void applyUpdate(JmxSubsystemElement element) throws UpdateFailedException {
        element.setConnector(null);
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController service = context.getServiceContainer().getService(JMXConnectorService.SERVICE_NAME);
        if (service == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
        }
    }

    public AbstractSubsystemUpdate<JmxSubsystemElement, ?> getCompensatingUpdate(JmxSubsystemElement original) {
        JMXConnectorElement connector = original.getConnector();
        if (connector == null) {
            return null;
        }
        return new JMXConnectorAdd(connector.getServerBinding(), connector.getRegistryBinding());
    }

    public Class<JmxSubsystemElement> getModelElementType() {
        return JmxSubsystemElement.class;
    }
}

