/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.jmx.JMXConnectorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

class JMXConnectorAdd
implements ModelUpdateOperationHandler {
    static final JMXConnectorAdd INSTANCE = new JMXConnectorAdd();
    static final String OPERATION_NAME = "add-connector";

    private JMXConnectorAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        final String serverBinding = operation.require("server-binding").asString();
        final String registryBinding = operation.require("registry-binding").asString();
        context.getSubModel().get("server-binding").set(serverBinding);
        context.getSubModel().get("registry-binding").set(registryBinding);
        ModelNode compensatingOperation = Util.getEmptyOperation((String)"remove-connector", (ModelNode)operation.require("address"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    JMXConnectorService.addService(target, serverBinding, registryBinding);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

