/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.jmx.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JMXSubsystemProviders {
    static final String RESOURCE_NAME = JMXSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("jmx"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.JMX_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "registry-binding", "description"}).set(bundle.getString("registry.binding"));
            subsystem.get(new String[]{"attributes", "registry-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "registry-binding", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "registry-binding", "min-occurs"}).set(1);
            subsystem.get(new String[]{"attributes", "registry-binding", "max-occurs"}).set(1);
            subsystem.get(new String[]{"attributes", "server-binding", "description"}).set(bundle.getString("server.binding"));
            subsystem.get(new String[]{"attributes", "server-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "server-binding", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "server-binding", "min-occurs"}).set(1);
            subsystem.get(new String[]{"attributes", "server-binding", "max-occurs"}).set(1);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation-name").set("read-resource");
            subsystem.get("description").set(bundle.getString("jmx.add"));
            return subsystem;
        }
    };
    static final DescriptionProvider JMX_CONNECTOR_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add-connector");
            op.get("description").set(bundle.getString("jmx.connector.add"));
            op.get(new String[]{"request-properties", "registry-binding", "description"}).set(bundle.getString("registry.binding"));
            op.get(new String[]{"request-properties", "registry-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "registry-binding", "required"}).set(true);
            op.get(new String[]{"request-properties", "registry-binding", "min-occurs"}).set(1);
            op.get(new String[]{"request-properties", "registry-binding", "max-occurs"}).set(1);
            op.get(new String[]{"request-properties", "server-binding", "description"}).set(bundle.getString("server.binding"));
            op.get(new String[]{"request-properties", "server-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "server-binding", "required"}).set(true);
            op.get(new String[]{"request-properties", "server-binding", "min-occurs"}).set(1);
            op.get(new String[]{"request-properties", "server-binding", "max-occurs"}).set(1);
            op.get("reply-properties").setEmptyObject();
            return op;
        }
    };
    static final DescriptionProvider JMX_CONNECTOR_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove-connector");
            op.get("description").set(bundle.getString("jmx.connector.remove"));
            op.get("request-properties").setEmptyObject();
            op.get("reply-properties").setEmptyObject();
            return op;
        }
    };

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

