/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.HashMap;
import java.util.Map;

enum Attribute {
    UNKNOWN(null),
    NAME("name"),
    SHOW_MODEL("show-model"),
    SERVER_BINDING("server-binding"),
    REGISTRY_BINDING("registry-binding"),
    USE_MANAGEMENT_ENDPOINT("use-management-endpoint"),
    VALUE("value");

    private final String name;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.getLocalName();
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

