/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.util.Map;
import java.util.Properties;
import org.jboss.as.jpa.hibernate4.HibernateAnnotationScanner;
import org.jboss.as.jpa.hibernate4.HibernateSecondLevelCache;
import org.jboss.as.jpa.hibernate4.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.hibernate4.management.HibernateManagementAdaptor;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    private volatile JBossAppServerJtaPlatform appServerJtaPlatform;

    public void injectJtaManager(JtaManager jtaManager) {
        this.appServerJtaPlatform = new JBossAppServerJtaPlatform(jtaManager);
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(pu, properties, "hibernate.id.new_generator_mappings", "true");
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.resource_scanner", HibernateAnnotationScanner.class.getName());
        properties.put("hibernate.classLoader.application", pu.getClassLoader());
        this.putPropertyIfAbsent(pu, properties, "hibernate.transaction.jta.platform", (Object)this.appServerJtaPlatform);
        properties.remove("hibernate.transaction.manager_lookup_class");
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.entitymanager_factory_name", pu.getScopedPersistenceUnitName());
        this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name", pu.getScopedPersistenceUnitName());
        if (!pu.getProperties().containsKey("hibernate.session_factory_name")) {
            this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name_is_jndi", Boolean.FALSE);
        }
    }

    public void addProviderDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, PersistenceUnitMetadata pu) {
        Properties properties = pu.getProperties();
        if (Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_second_level_cache"))) {
            HibernateSecondLevelCache.addSecondLevelCacheDependencies(registry, target, builder, pu);
        }
    }

    private void putPropertyIfAbsent(PersistenceUnitMetadata pu, Map properties, String property, Object value) {
        if (!pu.getProperties().containsKey(property)) {
            properties.put(property, value);
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.setThreadLocalPersistenceUnitMetadata(pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.clearThreadLocalPersistenceUnitMetadata();
    }

    public ManagementAdaptor getManagementAdaptor() {
        return HibernateManagementAdaptor.getInstance();
    }

    public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
        String cacheRegionPrefix = pu.getProperties().getProperty("hibernate.cache.region_prefix");
        return cacheRegionPrefix == null || cacheRegionPrefix.equals(pu.getScopedPersistenceUnitName());
    }

    public void cleanup(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.cleanup(pu);
    }
}

